/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.setup;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;

public class CountingErrorHandler
implements ErrorHandler {
    private Map<Class<? extends Throwable>, Integer> stats = new HashMap<Class<? extends Throwable>, Integer>();

    @Override
    public void handle(ErrorContext context) {
        this.register(context.getThrowable());
    }

    @Override
    public void handleException(String errorMsg, Throwable exception) {
        this.register(exception);
    }

    public int getCountFor(Class<? extends Throwable> throwable) {
        Integer count = this.stats.get(throwable);
        return count == null ? 0 : count;
    }

    private synchronized void register(Throwable exception) {
        Integer count = this.stats.get(exception.getClass());
        if (count == null) {
            this.stats.put(exception.getClass(), 1);
        } else {
            count = count + 1;
            this.stats.put(exception.getClass(), count);
        }
    }
}

