/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HibernateSearchResourceLoader
implements ResourceLoader {
    private static final Log log = LoggerFactory.make();
    private final ServiceManager serviceManager;

    public HibernateSearchResourceLoader(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream openResource(String resource) throws IOException {
        InputStream inputStream;
        ClassLoaderService classLoaderService = this.serviceManager.requestService(ClassLoaderService.class);
        try {
            inputStream = classLoaderService.locateResourceStream(resource);
        }
        finally {
            this.serviceManager.releaseService(ClassLoaderService.class);
        }
        if (inputStream == null) {
            throw log.unableToLoadResource(resource);
        }
        return inputStream;
    }

    @Override
    public <T> Class<? extends T> findClass(String className, Class<T> expectedType) {
        return ClassLoaderHelper.classForName(expectedType, className, HibernateSearchResourceLoader.describeComponent(className), this.serviceManager);
    }

    @Override
    public <T> T newInstance(String className, Class<T> expectedType) {
        return ClassLoaderHelper.instanceFromName(expectedType, className, HibernateSearchResourceLoader.describeComponent(className), this.serviceManager);
    }

    private static String describeComponent(String className) {
        return "Lucene Analyzer component " + className;
    }
}

