/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import infinispan.org.jboss.logging.Logger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.util.StringHelper;

public abstract class ObjectPropertyHelper<TypeMetadata>
implements PropertyHelper {
    private static final Log log = Logger.getMessageLogger(Log.class, ObjectPropertyHelper.class.getName());
    private static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";
    private static final TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");
    protected final EntityNamesResolver entityNamesResolver;

    protected ObjectPropertyHelper(EntityNamesResolver entityNamesResolver) {
        this.entityNamesResolver = entityNamesResolver;
    }

    protected DateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(GMT_TZ);
        return dateFormat;
    }

    @Override
    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        Class<?> propertyType = this.getPrimitivePropertyType(entityType, propertyPath);
        if (propertyType == null) {
            throw log.getPredicatesOnCompleteEmbeddedEntitiesNotAllowedException(StringHelper.join(propertyPath, "."));
        }
        if (Date.class.isAssignableFrom(propertyType)) {
            try {
                return this.getDateFormat().parse(value);
            }
            catch (ParseException e) {
                throw log.getInvalidDateLiteralException(value);
            }
        }
        if (Enum.class.isAssignableFrom(propertyType)) {
            try {
                return Enum.valueOf(propertyType, value);
            }
            catch (IllegalArgumentException e) {
                throw log.getInvalidEnumLiteralException(value, propertyType.getName());
            }
        }
        if (propertyType == String.class) {
            return value;
        }
        if (propertyType == Character.class || propertyType == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        try {
            if (propertyType == Double.class || propertyType == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (propertyType == Float.class || propertyType == Float.TYPE) {
                return Float.valueOf(value);
            }
            if (propertyType == Long.class || propertyType == Long.TYPE) {
                return Long.valueOf(value);
            }
            if (propertyType == Integer.class || propertyType == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (propertyType == Short.class || propertyType == Short.TYPE) {
                return Short.valueOf(value);
            }
            if (propertyType == Byte.class || propertyType == Byte.TYPE) {
                return Byte.valueOf(value);
            }
        }
        catch (NumberFormatException ex) {
            throw log.getInvalidNumericLiteralException(value);
        }
        if (propertyType == Boolean.class || propertyType == Boolean.TYPE) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw log.getInvalidBooleanLiteralException(value);
        }
        return value;
    }

    public abstract Class<?> getPrimitivePropertyType(String var1, List<String> var2);

    public abstract boolean hasProperty(String var1, List<String> var2);

    public abstract boolean hasEmbeddedProperty(String var1, List<String> var2);

    public abstract boolean isRepeatedProperty(String var1, List<String> var2);

    public abstract TypeMetadata getEntityMetadata(String var1);

    @Override
    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        return value;
    }
}

