/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.security.PrivilegedAction;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.hibernate.hql.ParsingException;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.LuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.embedded.impl.SecurityActions;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.util.KeyValuePair;

public class QueryEngine {
    private final AdvancedCache<?, ?> cache;
    private final QueryCache queryCache;
    private final SearchManager searchManager;
    private final SearchIntegrator searchFactory;
    private final QueryParser queryParser = new QueryParser();
    private final EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

        @Override
        public Class<?> getClassFromName(String entityName) {
            try {
                return Util.loadClassStrict((String)entityName, null);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    };

    public QueryEngine(AdvancedCache<?, ?> cache, SearchManager searchManager) {
        this.cache = cache;
        this.queryCache = ComponentRegistryUtils.getQueryCache(cache);
        this.searchManager = searchManager;
        this.searchFactory = searchManager != null ? searchManager.unwrap(SearchIntegrator.class) : null;
    }

    public Query buildQuery(QueryFactory queryFactory, String jpqlString, long startOffset, int maxResults) {
        block5: {
            if (this.searchManager != null) {
                try {
                    return this.buildLuceneQuery(queryFactory, jpqlString, startOffset, maxResults, null);
                }
                catch (ParsingException e) {
                    if (!e.getMessage().startsWith("HQL100002")) {
                        throw e;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().startsWith("HQL100001")) break block5;
                    throw e;
                }
            }
        }
        return new EmbeddedQuery(queryFactory, this.cache, this.makeFilter(this.cache, jpqlString, ReflectionMatcher.class), startOffset, maxResults);
    }

    private JPAFilterAndConverter makeFilter(final AdvancedCache<?, ?> cache, final String jpaQuery, final Class<? extends Matcher> matcherImplClass) {
        return SecurityActions.doPrivileged(new PrivilegedAction<JPAFilterAndConverter>(){

            @Override
            public JPAFilterAndConverter run() {
                JPAFilterAndConverter filter = new JPAFilterAndConverter(jpaQuery, matcherImplClass);
                filter.injectDependencies((Cache)cache);
                filter.getObjectFilter();
                return filter;
            }
        });
    }

    public LuceneQuery buildLuceneQuery(QueryFactory queryFactory, String jpqlString, long startOffset, int maxResults, org.apache.lucene.search.Query additionalLuceneQuery) {
        LuceneQueryParsingResult parsingResult;
        if (this.searchManager == null) {
            throw new IllegalStateException("Cannot run Lucene queries on a cache that does not have indexing enabled");
        }
        if (this.queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, LuceneQueryParsingResult.class);
            parsingResult = (LuceneQueryParsingResult)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.transformJpaToLucene(jpqlString);
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, parsingResult);
            }
        } else {
            parsingResult = this.transformJpaToLucene(jpqlString);
        }
        org.apache.lucene.search.Query luceneQuery = parsingResult.getQuery();
        if (additionalLuceneQuery != null) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(new BooleanClause(additionalLuceneQuery, BooleanClause.Occur.MUST));
            booleanQuery.add(new BooleanClause(luceneQuery, BooleanClause.Occur.MUST));
            luceneQuery = booleanQuery;
        }
        CacheQuery cacheQuery = this.searchManager.getQuery(luceneQuery, parsingResult.getTargetEntity());
        if (parsingResult.getSort() != null) {
            cacheQuery = cacheQuery.sort(parsingResult.getSort());
        }
        if (parsingResult.getProjections() != null && !parsingResult.getProjections().isEmpty()) {
            int projSize = parsingResult.getProjections().size();
            cacheQuery = cacheQuery.projection(parsingResult.getProjections().toArray(new String[projSize]));
        }
        if (startOffset >= 0L) {
            cacheQuery = cacheQuery.firstResult((int)startOffset);
        }
        if (maxResults >= 0) {
            cacheQuery = cacheQuery.maxResults(maxResults);
        }
        return new EmbeddedLuceneQuery(queryFactory, jpqlString, cacheQuery);
    }

    private LuceneQueryParsingResult transformJpaToLucene(String jpqlString) {
        LuceneProcessingChain processingChain = new LuceneProcessingChain.Builder(this.searchFactory, this.entityNamesResolver).buildProcessingChainForClassBasedEntities();
        return this.queryParser.parseQuery(jpqlString, processingChain);
    }
}

