/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneBooleanQueryExternalizer
extends AbstractExternalizer<BooleanQuery> {
    public Set<Class<? extends BooleanQuery>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{BooleanQuery.class});
    }

    public BooleanQuery readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        boolean disableCoord = input.readBoolean();
        BooleanQuery unserialized = new BooleanQuery(disableCoord);
        unserialized.setBoost(input.readFloat());
        unserialized.setMinimumNumberShouldMatch(UnsignedNumeric.readUnsignedInt((ObjectInput)input));
        int numberOfClauses = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        LuceneBooleanQueryExternalizer.assureNumberOfClausesLimit(numberOfClauses);
        BooleanClause[] booleanClauses = new BooleanClause[numberOfClauses];
        List<BooleanClause> clauses = unserialized.clauses();
        for (int i = 0; i < numberOfClauses; ++i) {
            this.appendReadClause(input, clauses);
        }
        return unserialized;
    }

    private void appendReadClause(ObjectInput input, List<BooleanClause> clauses) throws IOException, ClassNotFoundException {
        BooleanClause.Occur occur = (BooleanClause.Occur)((Object)input.readObject());
        Query q = (Query)input.readObject();
        BooleanClause clause = new BooleanClause(q, occur);
        clauses.add(clause);
    }

    private void writeClause(ObjectOutput output, BooleanClause booleanClause) throws IOException {
        output.writeObject((Object)booleanClause.getOccur());
        output.writeObject(booleanClause.getQuery());
    }

    public void writeObject(ObjectOutput output, BooleanQuery query) throws IOException {
        output.writeBoolean(query.isCoordDisabled());
        output.writeFloat(query.getBoost());
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)query.getMinimumNumberShouldMatch());
        List<BooleanClause> booleanClauses = query.clauses();
        int numberOfClauses = booleanClauses.size();
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)numberOfClauses);
        for (int i = 0; i < numberOfClauses; ++i) {
            this.writeClause(output, booleanClauses.get(i));
        }
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_QUERY_BOOLEAN;
    }

    private static void assureNumberOfClausesLimit(int numberOfClauses) {
        int maxClauseLimit = BooleanQuery.getMaxClauseCount();
        if (numberOfClauses > maxClauseLimit) {
            BooleanQuery.setMaxClauseCount(numberOfClauses);
        }
    }
}

