/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.CommandInitializer;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.CustomQueryCommand;
import org.infinispan.query.indexmanager.LuceneWorkTransformationVisitor;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractUpdateCommand
extends BaseRpcCommand
implements ReplicableCommand,
CustomQueryCommand {
    protected static final Log log = (Log)LogFactory.getLog(AbstractUpdateCommand.class, Log.class);
    protected SearchIntegrator searchFactory;
    protected String indexName;
    protected byte[] serializedModel;
    protected QueryInterceptor queryInterceptor;

    protected AbstractUpdateCommand(String cacheName) {
        super(cacheName);
    }

    public abstract Object perform(InvocationContext var1) throws Throwable;

    public abstract byte getCommandId();

    public Object[] getParameters() {
        return new Object[]{this.indexName, this.serializedModel};
    }

    public void setParameters(int commandId, Object[] parameters) {
        this.indexName = (String)parameters[0];
        this.serializedModel = (byte[])parameters[1];
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void fetchExecutionContext(CommandInitializer ci) {
        if (!ci.getCacheManager().cacheExists(this.cacheName)) {
            throw new CacheException("Cache named '" + this.cacheName + "' does not exist on this CacheManager, or was not started");
        }
        Cache cache = ci.getCacheManager().getCache(this.cacheName);
        SearchManager searchManager = Search.getSearchManager(cache);
        this.searchFactory = searchManager.unwrap(SearchIntegrator.class);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
    }

    public boolean canBlock() {
        return true;
    }

    protected List<LuceneWork> transformKeysToStrings(List<LuceneWork> luceneWorks) {
        ArrayList<LuceneWork> transformedWorks = new ArrayList<LuceneWork>(luceneWorks.size());
        for (LuceneWork lw : luceneWorks) {
            transformedWorks.add(this.transformKeyToStrings(lw));
        }
        return transformedWorks;
    }

    protected LuceneWork transformKeyToStrings(LuceneWork luceneWork) {
        KeyTransformationHandler keyTransformationHandler = this.queryInterceptor.getKeyTransformationHandler();
        return luceneWork.acceptIndexWorkVisitor(LuceneWorkTransformationVisitor.INSTANCE, keyTransformationHandler);
    }

    protected void setSerializedWorkList(byte[] serializedModel) {
        this.serializedModel = serializedModel;
    }

    protected void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

