/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.concurrent.ConcurrentMap;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.impl.WorkQueue;
import org.hibernate.search.backend.impl.WorkQueueSynchronization;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PostTransactionWorkQueueSynchronization
implements WorkQueueSynchronization {
    private static final Log log = LoggerFactory.make();
    private final QueueingProcessor queueingProcessor;
    private boolean consumed;
    private boolean prepared;
    private final ConcurrentMap<Object, WorkQueueSynchronization> queuePerTransaction;
    private final WorkQueue queue;
    private final Object transactionIdentifier;

    public PostTransactionWorkQueueSynchronization(Object transactionIdentifier, QueueingProcessor queueingProcessor, ConcurrentMap<Object, WorkQueueSynchronization> queuePerTransaction, ExtendedSearchIntegrator extendedIntegrator) {
        this.transactionIdentifier = transactionIdentifier;
        this.queueingProcessor = queueingProcessor;
        this.queuePerTransaction = queuePerTransaction;
        this.queue = new WorkQueue(extendedIntegrator);
    }

    @Override
    public void add(Work work) {
        this.queueingProcessor.add(work, this.queue);
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public void beforeCompletion() {
        if (this.prepared) {
            log.tracef("Transaction's beforeCompletion() phase already been processed, ignoring: %s", (Object)this);
        } else {
            log.tracef("Processing Transaction's beforeCompletion() phase: %s", (Object)this);
            this.queueingProcessor.prepareWorks(this.queue);
            this.prepared = true;
        }
    }

    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Performing work.", (Object)this);
                this.queueingProcessor.performWorks(this.queue);
            } else {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Cancelling work due to transaction status %d", (Object)this, (Object)i);
                this.queueingProcessor.cancelWorks(this.queue);
            }
        }
        finally {
            this.consumed = true;
            if (this.queuePerTransaction != null) {
                this.queuePerTransaction.remove(this.transactionIdentifier);
            }
        }
    }

    @Override
    public void flushWorks() {
        WorkQueue subQueue = this.queue.splitQueue();
        this.queueingProcessor.prepareWorks(subQueue);
        this.queueingProcessor.performWorks(subQueue);
    }
}

