/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.Arrays;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.util.StringHelper;

public class PropertyValueExpr
implements ValueExpr {
    protected final String[] propertyPath;
    protected final boolean isRepeated;
    protected final Class<?> primitiveType;

    public PropertyValueExpr(String[] propertyPath, boolean isRepeated, Class<?> primitiveType) {
        this.propertyPath = propertyPath;
        this.isRepeated = isRepeated;
        this.primitiveType = primitiveType;
    }

    public PropertyValueExpr(String propertyPath, boolean isRepeated, Class<?> primitiveType) {
        this(StringHelper.split(propertyPath), isRepeated, primitiveType);
    }

    public String[] getPropertyPath() {
        return this.propertyPath;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyValueExpr other = (PropertyValueExpr)o;
        return Arrays.equals(this.propertyPath, other.propertyPath);
    }

    public int hashCode() {
        return Arrays.hashCode(this.propertyPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PROP(");
        boolean isFirst = true;
        for (String p : this.propertyPath) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(p);
        }
        if (this.isRepeated) {
            sb.append('*');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toJpaString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String p : this.propertyPath) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('.');
            }
            sb.append(p);
        }
        return sb.toString();
    }
}

