/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.CommandInitializer;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.CustomQueryCommand;
import org.infinispan.query.indexmanager.LuceneWorkTransformationVisitor;
import org.infinispan.query.logging.Log;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractUpdateCommand
extends BaseRpcCommand
implements ReplicableCommand,
CustomQueryCommand {
    protected static final Log log = (Log)LogFactory.getLog(AbstractUpdateCommand.class, Log.class);
    protected SearchIntegrator searchFactory;
    protected String indexName;
    protected byte[] serializedModel;
    protected QueryInterceptor queryInterceptor;

    protected AbstractUpdateCommand(ByteString cacheName) {
        super(cacheName);
    }

    public abstract Object perform(InvocationContext var1) throws Throwable;

    public abstract byte getCommandId();

    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.indexName);
        MarshallUtil.marshallByteArray((byte[])this.serializedModel, (ObjectOutput)output);
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.indexName = input.readUTF();
        this.serializedModel = MarshallUtil.unmarshallByteArray((ObjectInput)input);
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void fetchExecutionContext(CommandInitializer ci) {
        String name = this.cacheName.toString();
        if (!ci.getCacheManager().cacheExists(name)) {
            throw new CacheException("Cache named '" + name + "' does not exist on this CacheManager, or was not started");
        }
        Cache cache = ci.getCacheManager().getCache(name);
        SearchManager searchManager = Search.getSearchManager(cache);
        this.searchFactory = searchManager.unwrap(SearchIntegrator.class);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
    }

    public boolean canBlock() {
        return true;
    }

    public String getIndexName() {
        return this.indexName;
    }

    protected List<LuceneWork> transformKeysToStrings(List<LuceneWork> luceneWorks) {
        ArrayList<LuceneWork> transformedWorks = new ArrayList<LuceneWork>(luceneWorks.size());
        for (LuceneWork lw : luceneWorks) {
            transformedWorks.add(this.transformKeyToStrings(lw));
        }
        return transformedWorks;
    }

    protected LuceneWork transformKeyToStrings(LuceneWork luceneWork) {
        KeyTransformationHandler keyTransformationHandler = this.queryInterceptor.getKeyTransformationHandler();
        return luceneWork.acceptIndexWorkVisitor(LuceneWorkTransformationVisitor.INSTANCE, keyTransformationHandler);
    }

    protected void setSerializedWorkList(byte[] serializedModel) {
        this.serializedModel = serializedModel;
    }

    protected void setIndexName(String indexName) {
        this.indexName = indexName;
    }
}

