/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import javax.management.MBeanServer;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.jcache.AbstractJCacheListenerAdapter;
import org.infinispan.jcache.AbstractJCacheNotifier;
import org.infinispan.jcache.Closeables;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.FailureEntryProcessorResult;
import org.infinispan.jcache.MutableJCacheEntry;
import org.infinispan.jcache.RIDelegatingCacheMXBean;
import org.infinispan.jcache.RIMBeanServerRegistrationUtility;
import org.infinispan.jcache.SuccessEntryProcessorResult;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractJCache<K, V>
implements Cache<K, V> {
    private static final Log log = (Log)LogFactory.getLog(AbstractJCache.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final MutableConfiguration<K, V> configuration;
    protected final ExpiryPolicy expiryPolicy;
    protected final AbstractJCacheNotifier<K, V> notifier;
    private final CacheManager cacheManager;
    protected CacheLoader<K, V> jcacheLoader;
    protected CacheWriter<? super K, ? super V> jcacheWriter;
    private final CacheMXBean mxBean;

    public AbstractJCache(MutableConfiguration<K, V> configuration, CacheManager cacheManager, AbstractJCacheNotifier<K, V> notifier) {
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        this.notifier = notifier;
        this.expiryPolicy = (ExpiryPolicy)configuration.getExpiryPolicyFactory().create();
        this.mxBean = new RIDelegatingCacheMXBean(this);
    }

    protected void addConfigurationListeners() {
        for (CacheEntryListenerConfiguration r : this.configuration.getCacheEntryListenerConfigurations()) {
            this.notifier.addListener(r, this, this.notifier);
        }
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.configuration)) {
            return (C)((Configuration)clazz.cast(this.configuration));
        }
        throw log.configurationClassNotSupported(clazz);
    }

    public AbstractJCache<K, V> checkNotNull(Object obj, String name) {
        if (obj == null) {
            throw log.parameterMustNotBeNull(name);
        }
        return this;
    }

    protected void setCacheLoader(CompleteConfiguration<K, V> c) {
        Factory cacheLoaderFactory = c.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            this.jcacheLoader = (CacheLoader)cacheLoaderFactory.create();
            this.addCacheLoaderAdapter(this.jcacheLoader);
        }
    }

    protected void setCacheWriter(CompleteConfiguration<K, V> c) {
        Factory cacheWriterFactory = c.getCacheWriterFactory();
        if (cacheWriterFactory != null) {
            this.jcacheWriter = (CacheWriter)cacheWriterFactory.create();
            this.addCacheWriterAdapter(this.jcacheWriter);
        }
    }

    protected abstract void addCacheLoaderAdapter(CacheLoader<K, V> var1);

    protected abstract void addCacheWriterAdapter(CacheWriter<? super K, ? super V> var1);

    protected void setListenerCompletion(CompletionListener listener) {
        if (listener != null) {
            listener.onCompletion();
        }
    }

    protected void setListenerException(CompletionListener listener, Throwable t) {
        if (listener != null) {
            if (t instanceof Exception) {
                listener.onException((Exception)t);
            } else {
                listener.onException((Exception)new CacheException(t));
            }
        }
    }

    protected List<K> filterLoadAllKeys(Set<? extends K> keys, boolean replaceExistingValues, boolean cacheEvict) {
        if (trace) {
            log.tracef("Before filtering, keys to load: %s", keys);
        }
        ArrayList<K> keysToLoad = new ArrayList<K>();
        for (K key : keys) {
            if (key == null) {
                throw log.parameterMustNotBeNull("Key");
            }
            if (cacheEvict && replaceExistingValues && this.containsKey(key)) {
                this.evict(key);
            }
            if (!replaceExistingValues && this.containsKey(key)) continue;
            keysToLoad.add(key);
        }
        if (trace) {
            log.tracef("After filtering, keys to load: %s", keysToLoad);
        }
        return keysToLoad;
    }

    protected Map<K, V> loadAllKeys(Collection<? extends K> keysToLoad) {
        try {
            return this.jcacheLoader.loadAll(keysToLoad);
        }
        catch (Exception e) {
            throw Exceptions.launderCacheLoaderException(e);
        }
    }

    protected void loadAllFromJCacheLoader(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener, BasicCache<K, V> cache, BasicCache<K, V> createCheckCache) {
        List<K> keysToLoad = this.filterLoadAllKeys(keys, replaceExistingValues, false);
        if (keysToLoad.isEmpty()) {
            this.setListenerCompletion(listener);
            return;
        }
        try {
            Map<K, V> loaded = this.loadAllKeys(keysToLoad);
            Iterator<Map.Entry<K, V>> it = loaded.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                if (entry.getValue() != null) continue;
                it.remove();
            }
            for (Map.Entry<K, V> entry : loaded.entrySet()) {
                K loadedKey = entry.getKey();
                V loadedValue = entry.getValue();
                this.put(cache, createCheckCache, loadedKey, loadedValue, false);
            }
            this.setListenerCompletion(listener);
        }
        catch (Throwable t) {
            this.setListenerException(listener, t);
        }
    }

    protected <T> T processEntryProcessor(MutableJCacheEntry<K, V> mutable, EntryProcessor<K, V, T> entryProcessor, Object[] arguments) {
        try {
            return (T)entryProcessor.process(mutable, arguments);
        }
        catch (Exception e) {
            throw Exceptions.launderEntryProcessorException(e);
        }
    }

    protected abstract AbstractJCache<K, V> checkNotClosed();

    protected AbstractJCache<K, V> verifyKeys(Set<? extends K> keys) {
        if (keys == null || keys.contains(null)) {
            throw new NullPointerException("keys is null or keys contains a null: " + keys);
        }
        return this;
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed().checkNotNull(entryProcessor, "entryProcessor").verifyKeys(keys);
        HashMap map = new HashMap(keys.size());
        for (K key : keys) {
            Object result;
            try {
                Object t = this.invoke(key, entryProcessor, arguments);
                result = t == null ? null : new SuccessEntryProcessorResult<Object>(t);
            }
            catch (Throwable t) {
                result = new FailureEntryProcessorResult(t);
            }
            if (result == null) continue;
            map.put(key, result);
        }
        return map;
    }

    protected abstract void evict(K var1);

    protected V put(BasicCache<K, V> cache, BasicCache<K, V> createCheckCache, K key, V value, boolean isPutIfAbsent) {
        boolean isCreated;
        Object prev = createCheckCache.get(key);
        boolean bl = isCreated = prev == null;
        if (!isCreated && isPutIfAbsent) {
            return (V)prev;
        }
        Duration ttl = isCreated ? Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.CREATION) : Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.UPDATE);
        try {
            Object ret;
            if (ttl == null || ttl.isEternal()) {
                ret = isPutIfAbsent ? cache.putIfAbsent(key, value) : cache.put(key, value);
            } else if (ttl.equals((Object)Duration.ZERO)) {
                ret = !isCreated ? cache.remove(key) : null;
            } else {
                long duration = ttl.getDurationAmount();
                TimeUnit timeUnit = ttl.getTimeUnit();
                ret = isPutIfAbsent ? cache.putIfAbsent(key, value, duration, timeUnit) : cache.put(key, value, duration, timeUnit);
            }
            return (V)ret;
        }
        catch (CacheListenerException e) {
            throw Exceptions.launderCacheListenerException(e);
        }
    }

    protected void updateTTLForAccessed(BasicCache<K, V> cache, K key, V value) {
        Duration ttl = Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.ACCESS);
        if (ttl != null) {
            if (ttl.equals((Object)Duration.ZERO)) {
                cache.remove(key);
            } else {
                long durationAmount = ttl.getDurationAmount();
                TimeUnit timeUnit = ttl.getTimeUnit();
                cache.put(key, value, durationAmount, timeUnit);
            }
        }
    }

    protected boolean replace(BasicCache<K, V> cache, BasicCache<K, V> existsCheckCache, K key, V oldValue, V value, boolean isConditional) {
        Object current;
        this.checkNotNull(value, "value");
        if (isConditional) {
            this.checkNotNull(oldValue, "oldValue");
        }
        if ((current = existsCheckCache.get(key)) != null) {
            if (isConditional && !current.equals(oldValue)) {
                this.updateTTLForAccessed(cache, key, value);
                return false;
            }
            Duration ttl = Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.UPDATE);
            if (ttl == null || ttl.isEternal()) {
                return isConditional ? cache.replace(key, oldValue, value) : cache.replace(key, value) != null;
            }
            if (ttl.equals((Object)Duration.ZERO)) {
                return cache.remove(key) != null;
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return isConditional ? cache.replace(key, oldValue, value, duration, timeUnit) : cache.replace(key, value, duration, timeUnit) != null;
        }
        return false;
    }

    protected V replace(BasicCache<K, V> cache, K key, V value) {
        this.checkNotNull(value, "value");
        boolean exists = cache.containsKey(key);
        if (exists) {
            Duration ttl = Expiration.getExpiry(this.expiryPolicy, Expiration.Operation.UPDATE);
            if (ttl == null || ttl.isEternal()) {
                return (V)cache.replace(key, value);
            }
            if (ttl.equals((Object)Duration.ZERO)) {
                return (V)cache.remove(key);
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return (V)cache.replace(key, value, duration, timeUnit);
        }
        return null;
    }

    protected boolean remove(BasicCache<K, V> cache, K key, V oldValue) {
        Object current = cache.get(key);
        if (current != null && !current.equals(oldValue)) {
            this.updateTTLForAccessed(cache, key, current);
            return false;
        }
        return cache.remove(key, oldValue);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected abstract MBeanServer getMBeanServer();

    protected Object getCacheMXBean() {
        return this.mxBean;
    }

    protected abstract Object getCacheStatisticsMXBean();

    public void setManagementEnabled(boolean enabled) {
        this.configuration.setManagementEnabled(enabled);
        if (enabled) {
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        }
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.configuration.setStatisticsEnabled(enabled);
        if (enabled) {
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
        }
    }

    protected abstract void addListener(AbstractJCacheListenerAdapter<K, V> var1);

    protected abstract void removeListener(AbstractJCacheListenerAdapter<K, V> var1);

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)this, clazz);
    }

    protected void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        if (listenerCfg == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        boolean alreadyExists = false;
        for (CacheEntryListenerConfiguration c : this.configuration.getCacheEntryListenerConfigurations()) {
            if (!c.equals(listenerCfg)) continue;
            alreadyExists = true;
        }
        if (alreadyExists) {
            throw new IllegalArgumentException("A CacheEntryListenerConfiguration can be registered only once");
        }
        this.configuration.addCacheEntryListenerConfiguration(listenerCfg);
    }

    protected void removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.configuration.removeCacheEntryListenerConfiguration(listenerCfg);
    }

    protected boolean statisticsEnabled() {
        return this.getConfiguration(CompleteConfiguration.class).isStatisticsEnabled();
    }

    public void close() {
        this.notifier.close();
        Closeables.close(this.expiryPolicy);
        Closeables.close(this.jcacheLoader);
        Closeables.close(this.jcacheWriter);
    }
}

