/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.cache.configuration.MutableConfiguration;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class RemoveTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Test
    public void remove_1arg_Closed() {
        this.cache.close();
        try {
            this.cache.remove(null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void remove_1arg_NullKey() throws Exception {
        try {
            Assert.assertFalse((boolean)this.cache.remove(null));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void remove_1arg_NotExistent() throws Exception {
        Long existingKey = System.currentTimeMillis();
        String existingValue = "value" + existingKey;
        this.cache.put((Object)existingKey, (Object)existingValue);
        Long keyNotExisting = existingKey + 1L;
        Assert.assertFalse((boolean)this.cache.remove((Object)keyNotExisting));
        Assert.assertEquals((Object)existingValue, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void remove_1arg_Existing() {
        Long key1 = System.currentTimeMillis();
        String value1 = "value" + key1;
        this.cache.put((Object)key1, (Object)value1);
        Long key2 = key1 + 1L;
        String value2 = "value" + key2;
        this.cache.put((Object)key2, (Object)value2);
        Assert.assertTrue((boolean)this.cache.remove((Object)key1));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key1));
        Assert.assertNull((Object)this.cache.get((Object)key1));
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void remove_1arg_EqualButNotSameKey() {
        Long key1 = System.currentTimeMillis();
        String value1 = "value" + key1;
        this.cache.put((Object)key1, (Object)value1);
        Long key2 = key1 + 1L;
        String value2 = "value" + key2;
        this.cache.put((Object)key2, (Object)value2);
        Long key3 = new Long(key1);
        Assert.assertNotSame((Object)key1, (Object)key3);
        Assert.assertTrue((boolean)this.cache.remove((Object)key3));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key1));
        Assert.assertNull((Object)this.cache.get((Object)key1));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key3));
        Assert.assertNull((Object)this.cache.get((Object)key3));
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void remove_2arg_Closed() {
        this.cache.close();
        try {
            this.cache.remove(null, null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void remove_2arg_NullKey() {
        try {
            this.cache.remove(null, (Object)"");
            Assert.fail((String)"should have thrown an exception - null key");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void remove_2arg_NullValue() {
        try {
            this.cache.remove((Object)1L, null);
            Assert.fail((String)"should have thrown an exception - null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void remove_2arg_NotThere() {
        Long key = System.currentTimeMillis();
        Assert.assertFalse((boolean)this.cache.remove((Object)key, (Object)""));
    }

    @Test
    public void remove_2arg_Existing_SameValue() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)this.cache.remove((Object)key, (Object)value));
    }

    @Test
    public void remove_2arg_Existing_EqualValue() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)this.cache.remove((Object)key, (Object)new String(value)));
    }

    @Test
    public void remove_2arg_Existing_EqualKey() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)this.cache.remove((Object)new Long(key), (Object)value));
    }

    @Test
    public void remove_2arg_Existing_EqualKey_EqualValue() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)this.cache.remove((Object)new Long(key), (Object)new String(value)));
    }

    @Test
    public void remove_2arg_Existing_Different() {
        Long key = System.currentTimeMillis();
        String value = "value" + key;
        this.cache.put((Object)key, (Object)value);
        Assert.assertFalse((boolean)this.cache.remove((Object)key, (Object)(value + 1)));
    }

    @Test
    public void getAndRemove_Closed() {
        this.cache.close();
        try {
            this.cache.getAndRemove(null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getAndRemove_NullKey() throws Exception {
        try {
            Assert.assertNull((Object)this.cache.getAndRemove(null));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAndRemove_NotExistent() throws Exception {
        Long existingKey = System.currentTimeMillis();
        String existingValue = "value" + existingKey;
        this.cache.put((Object)existingKey, (Object)existingValue);
        Long keyNotExisting = existingKey + 1L;
        Assert.assertNull((Object)this.cache.getAndRemove((Object)keyNotExisting));
        Assert.assertEquals((Object)existingValue, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void getAndRemove_Existing() {
        Long key1 = System.currentTimeMillis();
        String value1 = "value" + key1;
        this.cache.put((Object)key1, (Object)value1);
        Long key2 = key1 + 1L;
        String value2 = "value" + key2;
        this.cache.put((Object)key2, (Object)value2);
        Assert.assertEquals((Object)value1, (Object)this.cache.getAndRemove((Object)key1));
        Assert.assertFalse((boolean)this.cache.containsKey((Object)key1));
        Assert.assertNull((Object)this.cache.get((Object)key1));
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void getAndRemove_EqualButNotSameKey() {
        Long key1 = System.currentTimeMillis();
        String value1 = "value" + key1;
        this.cache.put((Object)key1, (Object)value1);
        Long key2 = key1 + 1L;
        String value2 = "value" + key2;
        this.cache.put((Object)key2, (Object)value2);
        Long key3 = new Long(key1);
        Assert.assertNotSame((Object)key3, (Object)key1);
        Assert.assertEquals((Object)value1, (Object)this.cache.getAndRemove((Object)key3));
        Assert.assertNull((Object)this.cache.get((Object)key1));
        Assert.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void removeAll_1arg_Closed() {
        this.cache.close();
        try {
            this.cache.removeAll(null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void removeAll_1arg_Null() {
        try {
            this.cache.removeAll(null);
            Assert.fail((String)"should have thrown an exception - null keys not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void removeAll_1arg_NullKey() {
        HashSet<Object> keys = new HashSet<Object>();
        keys.add(null);
        try {
            this.cache.removeAll(keys);
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void removeAll_1arg() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        this.cache.putAll(data);
        Iterator it = data.entrySet().iterator();
        it.next();
        Map.Entry removedEntry = it.next();
        it.remove();
        this.cache.removeAll(data.keySet());
        for (Long key : data.keySet()) {
            Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        }
        Assert.assertEquals(removedEntry.getValue(), (Object)this.cache.get((Object)((Long)removedEntry.getKey())));
    }

    @Test
    public void removeAll_0arg_Closed() {
        this.cache.close();
        try {
            this.cache.removeAll();
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void removeAll_0arg() {
        LinkedHashMap<Long, String> data = this.createLSData(3);
        this.cache.putAll(data);
        this.cache.removeAll();
        for (Long key : data.keySet()) {
            Assert.assertFalse((boolean)this.cache.containsKey((Object)key));
        }
    }
}

