/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.Cache;
import javax.cache.integration.CacheWriter;

public class RecordingCacheWriter<K, V>
implements CacheWriter<K, V>,
AutoCloseable {
    private ConcurrentHashMap<K, V> writtenKeys = new ConcurrentHashMap();
    private ConcurrentHashMap<K, V> deletedEntries = new ConcurrentHashMap();
    private AtomicLong writeCount = new AtomicLong();
    private AtomicLong deleteCount = new AtomicLong();

    public void write(Cache.Entry<? extends K, ? extends V> entry) {
        this.writtenKeys.put(entry.getKey(), entry.getValue());
        this.writeCount.incrementAndGet();
    }

    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        Iterator<Cache.Entry<K, V>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            this.write(iterator.next());
            iterator.remove();
        }
    }

    public void delete(Object key) {
        V value = this.writtenKeys.remove(key);
        if (value != null) {
            this.deletedEntries.put(key, value);
        }
        this.deleteCount.incrementAndGet();
    }

    public void deleteAll(Collection<?> entries) {
        Iterator<?> keys = entries.iterator();
        while (keys.hasNext()) {
            this.delete(keys.next());
            keys.remove();
        }
    }

    public V get(K key) {
        return this.writtenKeys.get(key);
    }

    public boolean hasWritten(K key) {
        return this.writtenKeys.containsKey(key);
    }

    public boolean hasDeleted(K key) {
        return this.deletedEntries.containsKey(key);
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public long getDeleteCount() {
        return this.deleteCount.get();
    }

    public void clear() {
        this.writtenKeys.clear();
        this.deletedEntries.clear();
        this.writeCount = new AtomicLong();
        this.deleteCount = new AtomicLong();
    }

    @Override
    public void close() throws Exception {
    }
}

