/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.expiry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.jsr107.tck.support.OperationHandler;
import org.jsr107.tck.support.Server;

public class ExpiryPolicyServer
extends Server {
    private ExpiryPolicy expiryPolicy;

    public ExpiryPolicyServer(int port) {
        this(port, null);
    }

    public ExpiryPolicyServer(int port, ExpiryPolicy expiryPolicy) {
        super(port);
        this.addOperationHandler(new GetExpiryOperationHandler());
        this.expiryPolicy = expiryPolicy;
    }

    public void setExpiryPolicy(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    public class GetExpiryOperationHandler
    implements OperationHandler {
        @Override
        public String getType() {
            return "getExpiry";
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            if (ExpiryPolicyServer.this.expiryPolicy == null) {
                throw new NullPointerException("The ExpiryPolicy for the ExpiryPolicyServer has not be set");
            }
            EntryOperation entryOperation = EntryOperation.valueOf((String)ois.readObject());
            try {
                Duration duration;
                switch (entryOperation) {
                    case CREATION: {
                        duration = ExpiryPolicyServer.this.expiryPolicy.getExpiryForCreation();
                        break;
                    }
                    case ACCESSED: {
                        duration = ExpiryPolicyServer.this.expiryPolicy.getExpiryForAccess();
                        break;
                    }
                    case UPDATED: {
                        duration = ExpiryPolicyServer.this.expiryPolicy.getExpiryForUpdate();
                        break;
                    }
                    default: {
                        duration = null;
                    }
                }
                oos.writeObject(duration);
            }
            catch (Exception e) {
                oos.writeObject(e);
            }
        }
    }

    public static enum EntryOperation {
        CREATION,
        ACCESSED,
        UPDATED;

    }
}

