/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.metadata.Metadata;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

public final class JPAProtobufFilterAndConverter
extends JPAFilterAndConverter<Object, Object> {
    private boolean usesValueWrapper;

    public void injectDependencies(Cache cache) {
        super.injectDependencies(cache);
        Configuration cfg = cache.getCacheConfiguration();
        this.usesValueWrapper = cfg.indexing().index().isEnabled() && !cfg.compatibility().enabled();
    }

    public JPAProtobufFilterAndConverter(String jpaQuery) {
        super(jpaQuery, ProtobufMatcher.class);
    }

    public ObjectFilter.FilterResult filterAndConvert(Object key, Object value, Metadata metadata) {
        if (value == null) {
            return null;
        }
        if (this.usesValueWrapper) {
            value = ((ProtobufValueWrapper)value).getBinary();
        }
        return this.getObjectFilter().filter(value);
    }

    public String toString() {
        return "JPAProtobufFilterAndConverter{jpaQuery='" + this.getJPAQuery() + "'}";
    }

    public static final class Externalizer
    extends AbstractExternalizer<JPAProtobufFilterAndConverter> {
        public void writeObject(ObjectOutput output, JPAProtobufFilterAndConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.getJPAQuery());
        }

        public JPAProtobufFilterAndConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new JPAProtobufFilterAndConverter(input.readUTF());
        }

        public Integer getId() {
            return ExternalizerIds.JPA_PROTOBUF_FILTER_AND_CONVERTER;
        }

        public Set<Class<? extends JPAProtobufFilterAndConverter>> getTypeClasses() {
            return Collections.singleton(JPAProtobufFilterAndConverter.class);
        }
    }
}

