/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access.management;

import infinispan.org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import infinispan.org.jboss.as.controller.access.constraint.ApplicationTypeConstraint;
import infinispan.org.jboss.as.controller.access.constraint.ConstraintFactory;
import infinispan.org.jboss.as.controller.access.management.AccessConstraintDefinition;
import infinispan.org.jboss.as.controller.access.management.AccessConstraintKey;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ApplicationTypeAccessConstraintDefinition
implements AccessConstraintDefinition {
    public static final ApplicationTypeAccessConstraintDefinition DEPLOYMENT = new ApplicationTypeAccessConstraintDefinition(ApplicationTypeConfig.DEPLOYMENT);
    public static final List<AccessConstraintDefinition> DEPLOYMENT_AS_LIST = DEPLOYMENT.wrapAsList();
    private final ApplicationTypeConfig applicationTypeConfig;
    private final AccessConstraintKey key;

    public ApplicationTypeAccessConstraintDefinition(ApplicationTypeConfig applicationTypeConfig) {
        this.applicationTypeConfig = applicationTypeConfig;
        this.key = new AccessConstraintKey("application-classification", applicationTypeConfig.isCore(), applicationTypeConfig.getSubsystem(), applicationTypeConfig.getName());
        ApplicationTypeConstraint.FACTORY.addApplicationTypeConfig(applicationTypeConfig);
    }

    @Override
    public ModelNode getModelDescriptionDetails(Locale locale) {
        return null;
    }

    @Override
    public ConstraintFactory getConstraintFactory() {
        return ApplicationTypeConstraint.FACTORY;
    }

    public ApplicationTypeConfig getApplicationTypeConfig() {
        return this.applicationTypeConfig;
    }

    @Override
    public String getName() {
        return this.applicationTypeConfig.getName();
    }

    @Override
    public String getType() {
        return "application";
    }

    @Override
    public boolean isCore() {
        return this.applicationTypeConfig.isCore();
    }

    @Override
    public String getSubsystemName() {
        return this.applicationTypeConfig.isCore() ? null : this.applicationTypeConfig.getSubsystem();
    }

    @Override
    public AccessConstraintKey getKey() {
        return this.key;
    }

    @Override
    public String getDescription(Locale locale) {
        return null;
    }

    public int hashCode() {
        return this.applicationTypeConfig.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ApplicationTypeAccessConstraintDefinition && this.applicationTypeConfig.equals(((ApplicationTypeAccessConstraintDefinition)obj).applicationTypeConfig);
    }

    public List<AccessConstraintDefinition> wrapAsList() {
        return Collections.singletonList(this);
    }
}

