/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access.rbac;

import infinispan.org.jboss.as.controller.access.Authorizer;
import infinispan.org.jboss.as.controller.access.AuthorizerConfiguration;
import infinispan.org.jboss.as.controller.access.Caller;
import infinispan.org.jboss.as.controller.access.Environment;
import infinispan.org.jboss.as.controller.access.permission.ManagementPermissionAuthorizer;
import infinispan.org.jboss.as.controller.access.rbac.DefaultPermissionFactory;
import infinispan.org.jboss.as.controller.access.rbac.RoleMapper;
import infinispan.org.jboss.as.controller.access.rbac.RunAsRoleMapper;
import infinispan.org.jboss.as.controller.access.rbac.StandardRole;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class StandardRBACAuthorizer
extends ManagementPermissionAuthorizer {
    private static final Set<String> STANDARD_ROLES;
    public static final Authorizer.AuthorizerDescription AUTHORIZER_DESCRIPTION;
    private final AuthorizerConfiguration configuration;
    private final DefaultPermissionFactory permissionFactory;
    private final RoleMapper roleMapper;
    private final Map<String, String> mappedToOfficialForm = Collections.synchronizedMap(new HashMap());

    public static StandardRBACAuthorizer create(AuthorizerConfiguration configuration, RoleMapper roleMapper) {
        RunAsRoleMapper runAsRoleMapper = new RunAsRoleMapper(roleMapper);
        DefaultPermissionFactory permissionFactory = new DefaultPermissionFactory(runAsRoleMapper, configuration);
        return new StandardRBACAuthorizer(configuration, permissionFactory, runAsRoleMapper);
    }

    private StandardRBACAuthorizer(AuthorizerConfiguration configuration, DefaultPermissionFactory permissionFactory, RoleMapper roleMapper) {
        super(permissionFactory);
        this.configuration = configuration;
        this.permissionFactory = permissionFactory;
        configuration.registerScopedRoleListener(permissionFactory);
        this.roleMapper = roleMapper;
        for (StandardRole std : StandardRole.values()) {
            this.mappedToOfficialForm.put(std.toString(), std.getFormalName());
        }
    }

    @Override
    public Set<String> getCallerRoles(Caller caller, Environment callEnvironment, Set<String> runAsRoles) {
        Set<String> mapped = this.roleMapper.mapRoles(caller, callEnvironment, runAsRoles);
        if (mapped == null) {
            return null;
        }
        if (mapped.isEmpty()) {
            return mapped;
        }
        HashSet<String> result = new HashSet<String>();
        for (String role : mapped) {
            result.add(this.getOfficialRoleForm(role));
        }
        return result;
    }

    private String getOfficialRoleForm(String role) {
        String official = this.mappedToOfficialForm.get(role);
        if (official == null) {
            for (String scoped : this.configuration.getScopedRoles().keySet()) {
                if (!role.equalsIgnoreCase(scoped)) continue;
                official = scoped;
                break;
            }
            if (official == null) {
                try {
                    StandardRole std = StandardRole.valueOf(role.toUpperCase(Locale.ENGLISH));
                    official = std.getFormalName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (official != null) {
                this.mappedToOfficialForm.put(role, official);
            } else {
                official = role;
            }
        }
        return official;
    }

    @Override
    public Authorizer.AuthorizerDescription getDescription() {
        return AUTHORIZER_DESCRIPTION;
    }

    public void shutdown() {
        this.configuration.unregisterScopedRoleListener(this.permissionFactory);
    }

    static {
        LinkedHashSet<String> stdRoles = new LinkedHashSet<String>();
        for (StandardRole stdRole : StandardRole.values()) {
            stdRoles.add(stdRole.getFormalName());
        }
        STANDARD_ROLES = stdRoles;
        AUTHORIZER_DESCRIPTION = new Authorizer.AuthorizerDescription(){

            @Override
            public boolean isRoleBased() {
                return true;
            }

            @Override
            public Set<String> getStandardRoles() {
                return STANDARD_ROLES;
            }
        };
    }
}

