/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.parsing;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ACCESS_CONTROL("access-control"),
    ADVANCED_FILTER("advanced-filter"),
    AGENT_LIB("agent-lib"),
    AGENT_PATH("agent-path"),
    ANY("any"),
    ANY_ADDRESS("any-address"),
    ANY_IPV4_ADDRESS("any-ipv4-address"),
    ANY_IPV6_ADDRESS("any-ipv6-address"),
    APPLICATION_CLASSIFICATION("application-classification"),
    APPLICATION_CLASSIFICATIONS("application-classifications"),
    AUDIT_LOG("audit-log"),
    AUTHENTICATION("authentication"),
    AUTHORIZATION("authorization"),
    CACHE("cache"),
    CLIENT_CERT_STORE("client-certificate-store"),
    CLIENT_MAPPING("client-mapping"),
    CONFIGURATION_CHANGES("configuration-changes"),
    CONSTRAINTS("constraints"),
    CONTENT("content"),
    DISCOVERY_OPTION("discovery-option"),
    DISCOVERY_OPTIONS("discovery-options"),
    DOMAIN("domain"),
    DOMAIN_CONTROLLER("domain-controller"),
    DEPLOYMENT("deployment"),
    DEPLOYMENTS("deployments"),
    DEPLOYMENT_OVERLAY("deployment-overlay"),
    DEPLOYMENT_OVERLAYS("deployment-overlays"),
    ENGINE("engine"),
    ENVIRONMENT_VARIABLES("environment-variables"),
    EXCLUDE("exclude"),
    EXCLUDED_EXTENSIONS("excluded-extensions"),
    EXTENSION("extension"),
    EXTENSIONS("extensions"),
    FILE_HANDLER("file-handler"),
    FORMATTER("formatter"),
    FORMATTERS("formatters"),
    FS_ARCHIVE("fs-archive"),
    FS_EXPLODED("fs-exploded"),
    GROUP("group"),
    GROUP_SEARCH("group-search"),
    GROUP_TO_PRINCIPAL("group-to-principal"),
    GROUPS_FILTER("groups-filter"),
    HANDLER("handler"),
    HANDLERS("handlers"),
    HEAP("heap"),
    HOST("host"),
    HOSTS("hosts"),
    HOST_API_VERSION("host-api-version"),
    HOST_EXCLUDE("host-exclude"),
    HOST_EXCLUDES("host-excludes"),
    HOST_RELEASE("host-release"),
    HOST_SCOPED_ROLES("host-scoped-roles"),
    HTTP_INTERFACE("http-interface"),
    IGNORED_RESOURCE("ignored-resources"),
    IN_MEMORY_HANDLER("in-memory-handler"),
    INCLUDE("include"),
    INSTANCE("instance"),
    INET_ADDRESS("inet-address"),
    INTERFACE("interface"),
    INTERFACE_SPECS("interface-specs"),
    INTERFACES("interfaces"),
    JAAS("jaas"),
    JAVA_AGENT("java-agent"),
    JSON_FORMATTER("json-formatter"),
    JVM("jvm"),
    JVMS("jvms"),
    JVM_OPTIONS("jvm-options"),
    KERBEROS("kerberos"),
    KEYSTORE("keystore"),
    KEYTAB("keytab"),
    LAUNCH_COMMAND("launch-command"),
    LDAP("ldap"),
    LINK_LOCAL_ADDRESS("link-local-address"),
    LOCAL("local"),
    LOCAL_DESTINATION("local-destination"),
    LOGGER("logger"),
    LOOPBACK("loopback"),
    LOOPBACK_ADDRESS("loopback-address"),
    MANAGEMENT("management"),
    MANAGEMENT_CLIENT_CONTENT("management-client-content"),
    MANAGEMENT_INTERFACES("management-interfaces"),
    MEMBERSHIP_FILTER("membership-filter"),
    MULTICAST("multicast"),
    NAME("name"),
    NATIVE_INTERFACE("native-interface"),
    NATIVE_REMOTING_INTERFACE("native-remoting-interface"),
    NIC("nic"),
    NIC_MATCH("nic-match"),
    NOT("not"),
    OPTION("option"),
    OUTBOUND_CONNECTIONS("outbound-connections"),
    OUTBOUND_SOCKET_BINDING("outbound-socket-binding"),
    PASSWORD("password"),
    PATH("path"),
    PATHS("paths"),
    PERIODIC_ROTATING_FILE_HANDLER("periodic-rotating-file-handler"),
    PERMGEN("permgen"),
    PLUG_IN("plug-in"),
    PLUG_INS("plug-ins"),
    POINT_TO_POINT("point-to-point"),
    PRINCIPAL_TO_GROUP("principal-to-group"),
    PROFILE("profile"),
    PROFILES("profiles"),
    PROPERTY("property"),
    PROPERTIES("properties"),
    PUBLIC_ADDRESS("public-address"),
    REMOTE("remote"),
    REMOTE_DESTINATION("remote-destination"),
    ROLE("role"),
    ROLE_MAPPING("role-mapping"),
    ROLLOUT_PLANS("rollout-plans"),
    SECRET("secret"),
    SECURITY_REALM("security-realm"),
    SECURITY_REALMS("security-realms"),
    SENSITIVE_CLASSIFICATION("sensitive-classification"),
    SENSITIVE_CLASSIFICATIONS("sensitive-classifications"),
    SERVER("server"),
    SERVER_GROUP_SCOPED_ROLES("server-group-scoped-roles"),
    SERVER_LOGGER("server-logger"),
    SERVER_IDENTITIES("server-identities"),
    SERVERS("servers"),
    SERVER_GROUP("server-group"),
    SERVER_GROUPS("server-groups"),
    SITE_LOCAL_ADDRESS("site-local-address"),
    SIZE_ROTATING_FILE_HANDLER("size-rotating-file-handler"),
    SOCKET("socket"),
    SOCKET_BINDING("socket-binding"),
    SOCKET_BINDINGS("socket-bindings"),
    SOCKET_BINDING_GROUP("socket-binding-group"),
    SOCKET_BINDING_GROUPS("socket-binding-groups"),
    SSL("ssl"),
    STACK("stack"),
    STATIC_DISCOVERY("static-discovery"),
    SUBNET_MATCH("subnet-match"),
    SUBSYSTEM("subsystem"),
    SYSLOG_HANDLER("syslog-handler"),
    SYSTEM_PROPERTIES("system-properties"),
    TCP("tcp"),
    TLS("tls"),
    TRUSTSTORE("truststore"),
    TYPE("type"),
    UDP("udp"),
    UP("up"),
    USER("user"),
    USERNAME_FILTER("username-filter"),
    USERNAME_IS_DN("username-is-dn"),
    USERNAME_TO_DN("username-to-dn"),
    USERS("users"),
    VARIABLE("variable"),
    VIRTUAL("virtual"),
    VAULT("vault"),
    VAULT_EXPRESSION_SENSITIVITY("vault-expression-sensitivity"),
    VAULT_OPTION("vault-option");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

