/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.infinispan.rhq.CacheManagerComponent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheDiscovery
extends MBeanResourceDiscoveryComponent<CacheManagerComponent> {
    private static final Log log = LogFactory.getLog(CacheDiscovery.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<CacheManagerComponent> ctx) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Discover resources with context");
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        EmsConnection conn = ((CacheManagerComponent)ctx.getParentResourceComponent()).getEmsConnection();
        if (trace) {
            log.trace((Object)"Connection to ems server established");
        }
        String pattern = this.getAllCachesPattern(ctx.getParentResourceContext().getResourceKey());
        if (trace) {
            log.tracef("Pattern to query is %s", (Object)pattern);
        }
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(pattern);
        List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
        if (trace) {
            log.tracef("Querying [%s] returned beans: %s", (Object)queryUtility.getTranslatedQuery(), (Object)beans);
        }
        for (EmsBean bean : beans) {
            String name = bean.getAttribute("CacheName").getValue().toString();
            if (trace) {
                log.tracef("Resource name is %s", (Object)name);
            }
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(ctx.getResourceType(), name, name, null, "One cache within Infinispan", ctx.getDefaultPluginConfiguration(), null);
            discoveredResources.add(detail);
            log.info((Object)("Discovered new ...  " + bean.getBeanName().getCanonicalName()));
        }
        return discoveredResources;
    }

    private String getAllCachesPattern(String cacheManagerName) {
        return CacheDiscovery.cacheComponentPattern(cacheManagerName, "Cache") + ",*";
    }

    protected static String cacheComponentPattern(String cacheManagerName, String componentName) {
        return "*:type=Cache,component=" + componentName + ",manager=" + ObjectName.quote(cacheManagerName);
    }
}

