/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.store;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfiguration;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.integration.data.KeyValueEntity;
import org.infinispan.test.integration.protostream.ServerIntegrationSCIImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractInfinispanStoreJpaIT {
    private EmbeddedCacheManager cm;

    @After
    public void cleanUp() {
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    @Test
    public void testCacheManager() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.defaultCacheName("default");
        gcb.serialization().addContextInitializer((SerializationContextInitializer)new ServerIntegrationSCIImpl());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((JpaStoreConfigurationBuilder)((JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class)).persistenceUnitName("org.infinispan.persistence.jpa").segmented(false)).entityClass(KeyValueEntity.class);
        this.cm = new DefaultCacheManager(gcb.build(), builder.build());
        Cache cache = this.cm.getCache();
        KeyValueEntity entity = new KeyValueEntity("a", "a");
        cache.put((Object)entity.getK(), (Object)entity);
        Assert.assertEquals((Object)"a", (Object)((KeyValueEntity)cache.get((Object)entity.getK())).getValue());
    }

    @Test
    public void testXmlConfig() throws IOException {
        this.cm = new DefaultCacheManager("jpa-config.xml");
        Cache specificCache = this.cm.getCache("specificCache");
        this.validateConfig((Cache<String, KeyValueEntity>)specificCache);
        KeyValueEntity entity = new KeyValueEntity("k", "v");
        specificCache.put((Object)entity.getK(), (Object)entity);
    }

    private void validateConfig(Cache<String, KeyValueEntity> vehicleCache) {
        StoreConfiguration config = (StoreConfiguration)vehicleCache.getCacheConfiguration().persistence().stores().get(0);
        Assert.assertTrue((boolean)(config instanceof JpaStoreConfiguration));
        JpaStoreConfiguration jpaConfig = (JpaStoreConfiguration)config;
        Assert.assertEquals((long)1L, (long)jpaConfig.batchSize());
        Assert.assertEquals(KeyValueEntity.class, (Object)jpaConfig.entityClass());
    }
}

