/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.support.embedded;

import org.infinispan.Cache;
import org.infinispan.test.fwk.TestResourceTracker;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
@ContextConfiguration(value={"classpath:/org/infinispan/spring/support/embedded/InfinispanDefaultCacheFactoryBeanContextTest.xml"})
@Test(testName="spring.support.InfinispanDefaultCacheFactoryBeanContextTest", groups={"unit"})
public class InfinispanDefaultCacheFactoryBeanContextTest
extends AbstractTestNGSpringContextTests {
    private static final String DEFAULT_CACHE_NAME = "testDefaultCache";

    @BeforeSuite
    public void beforeSuit() {
        TestResourceTracker.testStarted((String)((Object)((Object)this)).getClass().getName());
    }

    @AfterSuite
    public void afterSuite() {
        TestResourceTracker.testFinished((String)((Object)((Object)this)).getClass().getName());
    }

    @Test
    public final void shouldProduceANonNullCache() {
        Cache testDefaultCache = (Cache)this.applicationContext.getBean(DEFAULT_CACHE_NAME, Cache.class);
        AssertJUnit.assertNotNull((String)"Spring application context should contain an Infinispan cache under the bean name \"testDefaultCache\". However, it doesn't.", (Object)testDefaultCache);
    }

    @Test
    public final void shouldAlwaysReturnTheSameCache() {
        Cache testDefaultCache1 = (Cache)this.applicationContext.getBean(DEFAULT_CACHE_NAME, Cache.class);
        Cache testDefaultCache2 = (Cache)this.applicationContext.getBean(DEFAULT_CACHE_NAME, Cache.class);
        AssertJUnit.assertSame((String)"InfinispanDefaultCacheFactoryBean should always return the same cache instance when being called repeatedly. However, the cache instances are not the same.", (Object)testDefaultCache1, (Object)testDefaultCache2);
    }
}

