/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.invoker;

import java.util.Arrays;
import java.util.EnumSet;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.util.concurrent.TimeoutException;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.SimpleCacheInvoker;

public class RetryingCacheInvoker
implements CacheInvoker {
    private final CacheInvoker invoker;
    private final int[] backOffIntervals;

    public RetryingCacheInvoker(int ... backOffIntervals) {
        this(new SimpleCacheInvoker(), backOffIntervals);
    }

    public RetryingCacheInvoker(CacheInvoker invoker, int ... backOffIntervals) {
        this.invoker = invoker;
        this.backOffIntervals = backOffIntervals;
    }

    @Override
    public <K, V, R> R invoke(Cache<K, V> cache, CacheInvoker.Operation<K, V, R> operation, Flag ... allFlags) {
        Flag[] attemptFlags = null;
        if (allFlags != null && allFlags.length > 0) {
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            flags.addAll(Arrays.asList(allFlags));
            flags.remove(Flag.FAIL_SILENTLY);
            attemptFlags = flags.toArray(new Flag[flags.size()]);
        }
        TimeoutException exception = null;
        for (int i = 0; i <= this.backOffIntervals.length; ++i) {
            try {
                return this.invoker.invoke(cache, operation, i < this.backOffIntervals.length ? attemptFlags : allFlags);
            }
            catch (TimeoutException e) {
                exception = e;
                if (i >= this.backOffIntervals.length) continue;
                int delay = this.backOffIntervals[i];
                try {
                    if (InfinispanLogger.ROOT_LOGGER.isTraceEnabled()) {
                        InfinispanLogger.ROOT_LOGGER.tracef(exception, "Cache operation failed.  Retrying in %d ms", delay);
                    }
                    Thread.sleep(delay);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        throw InfinispanMessages.MESSAGES.abortingCacheOperation(exception, this.backOffIntervals.length + 1);
    }
}

