/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.security.mappers.CommonNameRoleMapper;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationRoleResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteStateTransferConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheAuthorizationConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerModuleResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.CompatibilityConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.GlobalStateResource;
import org.jboss.as.clustering.infinispan.subsystem.IndexingConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.LoaderConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.PersistenceConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.SoftIndexConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final XMLElementWriter<SubsystemMarshallingContext> INSTANCE = new InfinispanSubsystemXMLWriter();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(InfinispanSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            for (Property entry : model.get("cache-container").asPropertyList()) {
                String containerName = entry.getName();
                ModelNode container = entry.getValue();
                writer.writeStartElement(Element.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), containerName);
                this.writeListAsAttribute(writer, Attribute.ALIASES, container, "aliases");
                this.writeOptional(writer, Attribute.DEFAULT_CACHE, container, "default-cache");
                this.writeOptional(writer, Attribute.JNDI_NAME, container, "jndi-name");
                this.writeOptional(writer, Attribute.START, container, "start");
                this.writeOptional(writer, Attribute.MODULE, container, "module");
                this.writeOptional(writer, Attribute.STATISTICS, container, "statistics");
                if (container.hasDefined("transport")) {
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ModelNode transport = container.get(new String[]{"transport", "TRANSPORT"});
                    this.writeOptional(writer, Attribute.CHANNEL, transport, "channel");
                    this.writeOptional(writer, Attribute.LOCK_TIMEOUT, transport, "lock-timeout");
                    this.writeOptional(writer, Attribute.STRICT_PEER_TO_PEER, transport, "strict-peer-to-peer");
                    this.writeOptional(writer, Attribute.INITIAL_CLUSTER_SIZE, transport, "initial-cluster-size");
                    this.writeOptional(writer, Attribute.INITIAL_CLUSTER_TIMEOUT, transport, "initial-cluster-timeout");
                    writer.writeEndElement();
                }
                if (container.hasDefined("security")) {
                    writer.writeStartElement(Element.SECURITY.getLocalName());
                    ModelNode security = container.get(new String[]{"security", "SECURITY"});
                    if (security.hasDefined("authorization")) {
                        ModelNode roles;
                        writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
                        ModelNode authorization = security.get(new String[]{"authorization", "AUTHORIZATION"});
                        if (authorization.hasDefined("mapper")) {
                            String mapper = authorization.get("mapper").asString();
                            if (CommonNameRoleMapper.class.getName().equals(mapper)) {
                                writer.writeEmptyElement(Element.COMMON_NAME_ROLE_MAPPER.getLocalName());
                            } else if (ClusterRoleMapper.class.getName().equals(mapper)) {
                                writer.writeEmptyElement(Element.CLUSTER_ROLE_MAPPER.getLocalName());
                            } else if (IdentityRoleMapper.class.getName().equals(mapper)) {
                                writer.writeEmptyElement(Element.IDENTITY_ROLE_MAPPER.getLocalName());
                            } else {
                                writer.writeStartElement(Element.CUSTOM_ROLE_MAPPER.getLocalName());
                                writer.writeAttribute(Attribute.CLASS.getLocalName(), mapper);
                                writer.writeEndElement();
                            }
                        }
                        if ((roles = authorization.get("role")).isDefined()) {
                            for (ModelNode roleNode : roles.asList()) {
                                ModelNode role = roleNode.get(0);
                                writer.writeStartElement(Element.ROLE.getLocalName());
                                AuthorizationRoleResource.NAME.marshallAsAttribute(role, (XMLStreamWriter)writer);
                                this.writeListAsAttribute(writer, Attribute.PERMISSIONS, role, "permissions");
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (container.hasDefined("global-state")) {
                    writer.writeStartElement(Element.GLOBAL_STATE.getLocalName());
                    ModelNode globalState = container.get(new String[]{"global-state", "GLOBAL_STATE"});
                    this.writeStatePathElement(Element.PERSISTENT_LOCATION, "persistent-location", writer, globalState);
                    this.writeStatePathElement(Element.SHARED_PERSISTENT_LOCATION, "shared-persistent-location", writer, globalState);
                    this.writeStatePathElement(Element.TEMPORARY_LOCATION, "temporary-location", writer, globalState);
                    if (globalState.hasDefined("configuration-storage")) {
                        ConfigurationStorage configurationStorage = ConfigurationStorage.valueOf((String)globalState.get("configuration-storage").asString());
                        switch (configurationStorage) {
                            case IMMUTABLE: {
                                writer.writeEmptyElement(Element.IMMUTABLE_CONFIGURATION_STORAGE.getLocalName());
                                break;
                            }
                            case VOLATILE: {
                                writer.writeEmptyElement(Element.VOLATILE_CONFIGURATION_STORAGE.getLocalName());
                                break;
                            }
                            case OVERLAY: {
                                writer.writeEmptyElement(Element.OVERLAY_CONFIGURATION_STORAGE.getLocalName());
                                break;
                            }
                            case MANAGED: {
                                writer.writeEmptyElement(Element.MANAGED_CONFIGURATION_STORAGE.getLocalName());
                                break;
                            }
                            case CUSTOM: {
                                writer.writeStartElement(Element.CUSTOM_CONFIGURATION_STORAGE.getLocalName());
                                writer.writeAttribute(Attribute.CLASS.getLocalName(), globalState.get("configuration-storage-class").asString());
                                writer.writeEndElement();
                            }
                        }
                    }
                    writer.writeEndElement();
                }
                if (container.hasDefined(ThreadPoolResource.WILDCARD_PATH.getKey())) {
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.ASYNC_OPERATIONS_THREAD_POOL, ThreadPoolResource.ASYNC_OPERATIONS, writer, container);
                    InfinispanSubsystemXMLWriter.writeScheduledThreadPoolElements(Element.EXPIRATION_THREAD_POOL, ScheduledThreadPoolResource.EXPIRATION, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.LISTENER_THREAD_POOL, ThreadPoolResource.LISTENER, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.PERSISTENCE_THREAD_POOL, ThreadPoolResource.PERSISTENCE, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.REMOTE_COMMAND_THREAD_POOL, ThreadPoolResource.REMOTE_COMMAND, writer, container);
                    InfinispanSubsystemXMLWriter.writeScheduledThreadPoolElements(Element.REPLICATION_QUEUE_THREAD_POOL, ScheduledThreadPoolResource.REPLICATION_QUEUE, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.STATE_TRANSFER_THREAD_POOL, ThreadPoolResource.STATE_TRANSFER, writer, container);
                    InfinispanSubsystemXMLWriter.writeThreadPoolElements(Element.TRANSPORT_THREAD_POOL, ThreadPoolResource.TRANSPORT, writer, container);
                }
                if (container.hasDefined("modules")) {
                    writer.writeStartElement(Element.MODULES.getLocalName());
                    ModelNode modules = container.get(new String[]{"modules", "MODULES", "module"});
                    for (ModelNode moduleNode : modules.asList()) {
                        if (!moduleNode.isDefined()) continue;
                        ModelNode modelNode = moduleNode.get(0);
                        writer.writeStartElement(Element.MODULE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeAttribute(writer, modelNode, (AttributeDefinition)CacheContainerModuleResource.NAME);
                        if (modelNode.hasDefined("slot")) {
                            InfinispanSubsystemXMLWriter.writeAttribute(writer, modelNode, (AttributeDefinition)CacheContainerModuleResource.SLOT);
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                ModelNode configurations = container.get(new String[]{"configurations", "CONFIGURATIONS"});
                this.processCacheConfiguration(writer, container, configurations, "local-cache");
                this.processCacheConfiguration(writer, container, configurations, "invalidation-cache");
                this.processCacheConfiguration(writer, container, configurations, "replicated-cache");
                this.processCacheConfiguration(writer, container, configurations, "distributed-cache");
                this.processCounterConfigurations(writer, container);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeStatePathElement(Element element, String name, XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            ModelNode pathNode = node.get(name);
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, pathNode, (AttributeDefinition)GlobalStateResource.PATH);
            this.writeOptional(writer, Attribute.RELATIVE_TO, pathNode, "relative-to");
            writer.writeEndElement();
        }
    }

    private static void writeThreadPoolElements(Element element, ThreadPoolResource pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        ModelNode threadPool;
        if (container.get(pool.getPathElement().getKey()).hasDefined(pool.getPathElement().getValue()) && InfinispanSubsystemXMLWriter.hasDefined(threadPool = container.get(pool.getPathElement().getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }

    private static void writeScheduledThreadPoolElements(Element element, ScheduledThreadPoolResource pool, XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        ModelNode threadPool;
        if (container.get(pool.getPathElement().getKey()).hasDefined(pool.getPathElement().getValue()) && InfinispanSubsystemXMLWriter.hasDefined(threadPool = container.get(pool.getPathElement().getKeyValuePair()), pool.getAttributes())) {
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttributes(writer, threadPool, pool.getAttributes());
            writer.writeEndElement();
        }
    }

    private void processCounterConfigurations(XMLExtendedStreamWriter writer, ModelNode container) throws XMLStreamException {
        if (container.hasDefined("counters")) {
            writer.writeStartElement(Element.COUNTERS.getLocalName());
            ModelNode counterRoot = container.get(new String[]{"counters", "COUNTERS"});
            this.writeOptional(writer, Attribute.RELIABILITY, counterRoot, "reliability");
            this.writeOptional(writer, Attribute.NUM_OWNERS, counterRoot, "num-owners");
            this.processStrongCounterConfigurations(writer, counterRoot.get("strong-counter"));
            this.processWeakCounterConfigurations(writer, counterRoot.get("weak-counter"));
            writer.writeEndElement();
        }
    }

    private void processWeakCounterConfigurations(XMLExtendedStreamWriter writer, ModelNode configurations) throws XMLStreamException {
        if (configurations != null && configurations.isDefined()) {
            for (Property e : configurations.asPropertyList()) {
                this.processWeakCounterConfiguration(writer, e.getValue());
            }
        }
    }

    private void processStrongCounterConfigurations(XMLExtendedStreamWriter writer, ModelNode configurations) throws XMLStreamException {
        if (configurations != null && configurations.isDefined()) {
            for (Property e : configurations.asPropertyList()) {
                this.processStrongCounterConfiguration(writer, e.getValue());
            }
        }
    }

    private void processWeakCounterConfiguration(XMLExtendedStreamWriter writer, ModelNode weakConfiguration) throws XMLStreamException {
        writer.writeStartElement(Element.WEAK_COUNTER.getLocalName());
        this.writeRequired(writer, Attribute.NAME, weakConfiguration, "name");
        this.writeOptional(writer, Attribute.INITIAL_VALUE, weakConfiguration, "initial-value");
        this.writeOptional(writer, Attribute.STORAGE, weakConfiguration, "storage");
        this.writeOptional(writer, Attribute.CONCURRENCY_LEVEL, weakConfiguration, "concurrency-level");
        writer.writeEndElement();
    }

    private void processStrongCounterConfiguration(XMLExtendedStreamWriter writer, ModelNode strongConfiguration) throws XMLStreamException {
        writer.writeStartElement(Element.STRONG_COUNTER.getLocalName());
        this.writeRequired(writer, Attribute.NAME, strongConfiguration, "name");
        this.writeOptional(writer, Attribute.INITIAL_VALUE, strongConfiguration, "initial-value");
        this.writeOptional(writer, Attribute.STORAGE, strongConfiguration, "storage");
        if (strongConfiguration.hasDefined("lower-bound")) {
            writer.writeStartElement(Element.LOWER_BOUND.getLocalName());
            this.writeRequired(writer, Attribute.VALUE, strongConfiguration, "lower-bound");
            writer.writeEndElement();
        }
        if (strongConfiguration.hasDefined("upper-bound")) {
            writer.writeStartElement(Element.UPPER_BOUND.getLocalName());
            this.writeRequired(writer, Attribute.VALUE, strongConfiguration, "upper-bound");
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void processCacheConfiguration(XMLExtendedStreamWriter writer, ModelNode container, ModelNode configurations, String cacheType) throws XMLStreamException {
        String cacheConfigurationType = cacheType + "-configuration";
        HashMap<String, List> configurationMappings = new HashMap<String, List>();
        if (container.get(cacheType).isDefined()) {
            for (Property cacheEntry : container.get(cacheType).asPropertyList()) {
                String cacheName = cacheEntry.getName();
                String configurationName = cacheEntry.getValue().get("configuration").asString();
                configurationMappings.compute(configurationName, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>();
                    }
                    v.add(cacheName);
                    return v;
                });
            }
        }
        if (configurations.get(cacheConfigurationType).isDefined()) {
            for (Property cacheEntry : configurations.get(cacheConfigurationType).asPropertyList()) {
                Element element;
                String name = cacheEntry.getName();
                ModelNode cacheConfiguration = cacheEntry.getValue();
                boolean identity = false;
                List caches = (List)configurationMappings.get(name);
                if (caches != null && caches.size() == 1 && ((String)caches.get(0)).equals(name)) {
                    element = Element.forName(cacheType);
                    identity = true;
                } else {
                    element = Element.forName(cacheConfigurationType);
                }
                writer.writeStartElement(element.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                switch (cacheType) {
                    case "distributed-cache": {
                        this.processDistributedCacheAttributes(writer, cacheConfiguration);
                    }
                    case "replicated-cache": 
                    case "invalidation-cache": {
                        this.processCommonClusteredCacheAttributes(writer, cacheConfiguration);
                    }
                }
                this.processCommonCacheConfigurationAttributesElements(writer, cacheConfiguration);
                writer.writeEndElement();
                if (identity || caches == null) continue;
                for (String cache : caches) {
                    writer.writeStartElement(Element.forName(cacheType).getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), cache);
                    writer.writeAttribute(Attribute.CONFIGURATION.getLocalName(), name);
                    writer.writeEndElement();
                }
            }
        }
    }

    private void processDistributedCacheAttributes(XMLExtendedStreamWriter writer, ModelNode distributedCache) throws XMLStreamException {
        this.writeOptional(writer, Attribute.OWNERS, distributedCache, "owners");
        this.writeOptional(writer, Attribute.SEGMENTS, distributedCache, "segments");
        this.writeOptional(writer, Attribute.CAPACITY_FACTOR, distributedCache, "capacity-factor");
        this.writeOptional(writer, Attribute.L1_LIFESPAN, distributedCache, "l1-lifespan");
    }

    private void processCommonClusteredCacheAttributes(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        this.writeOptional(writer, Attribute.MODE, cache, "mode");
        this.writeOptional(writer, Attribute.REMOTE_TIMEOUT, cache, "remote-timeout");
    }

    private void processCommonCacheConfigurationAttributesElements(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        ModelNode memory;
        ModelNode dataType;
        this.writeOptional(writer, Attribute.CONFIGURATION, cache, "configuration");
        this.writeOptional(writer, Attribute.START, cache, "start");
        this.writeOptional(writer, Attribute.BATCHING, cache, "batching");
        this.writeOptional(writer, Attribute.JNDI_NAME, cache, "jndi-name");
        this.writeOptional(writer, Attribute.MODULE, cache, "module");
        this.writeOptional(writer, Attribute.SIMPLE_CACHE, cache, "simple-cache");
        this.writeOptional(writer, Attribute.STATISTICS, cache, "statistics");
        this.writeOptional(writer, Attribute.STATISTICS_AVAILABLE, cache, "statistics-available");
        if (cache.get("backup").isDefined()) {
            writer.writeStartElement(Element.BACKUPS.getLocalName());
            for (Property property : cache.get("backup").asPropertyList()) {
                ModelNode stateTransfer;
                writer.writeStartElement(Element.BACKUP.getLocalName());
                writer.writeAttribute(Attribute.SITE.getLocalName(), property.getName());
                ModelNode backup = property.getValue();
                BackupSiteConfigurationResource.FAILURE_POLICY.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteConfigurationResource.STRATEGY.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteConfigurationResource.REPLICATION_TIMEOUT.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteConfigurationResource.ENABLED.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                if (backup.hasDefined("after-failures") || backup.hasDefined("min-wait")) {
                    writer.writeStartElement(Element.TAKE_OFFLINE.getLocalName());
                    BackupSiteConfigurationResource.TAKE_OFFLINE_AFTER_FAILURES.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                    BackupSiteConfigurationResource.TAKE_OFFLINE_MIN_WAIT.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (backup.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined() && ((stateTransfer = backup.get(new String[]{"state-transfer", "STATE_TRANSFER"})).hasDefined("chunk-size") || stateTransfer.hasDefined("timeout") || stateTransfer.hasDefined("max-retries") || stateTransfer.hasDefined("wait-time"))) {
                    writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_CHUNK_SIZE.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_TIMEOUT.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_MAX_RETRIES.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    BackupSiteStateTransferConfigurationResource.STATE_TRANSFER_WAIT_TIME.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if ((dataType = cache.get("encoding")).isDefined()) {
            ModelNode value;
            writer.writeStartElement(Element.DATA_TYPE.getLocalName());
            ModelNode key = dataType.get("key");
            if (key.isDefined()) {
                writer.writeStartElement(Element.KEY.getLocalName());
                this.writeOptional(writer, Attribute.MEDIA_TYPE, key, "media-type");
                writer.writeEndElement();
            }
            if ((value = dataType.get("value")).isDefined()) {
                writer.writeStartElement(Element.VALUE.getLocalName());
                this.writeOptional(writer, Attribute.MEDIA_TYPE, value, "media-type");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.get("remote-cache").isDefined() || cache.get("remote-site").isDefined()) {
            writer.writeStartElement(Element.BACKUP_FOR.getLocalName());
            CacheConfigurationResource.REMOTE_CACHE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            CacheConfigurationResource.REMOTE_SITE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
            writer.writeStartElement(Element.LOCKING.getLocalName());
            ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
            this.writeOptional(writer, Attribute.ISOLATION, locking, "isolation");
            this.writeOptional(writer, Attribute.STRIPING, locking, "striping");
            this.writeOptional(writer, Attribute.ACQUIRE_TIMEOUT, locking, "acquire-timeout");
            this.writeOptional(writer, Attribute.CONCURRENCY_LEVEL, locking, "concurrency-level");
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            writer.writeStartElement(Element.TRANSACTION.getLocalName());
            ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
            this.writeOptional(writer, Attribute.STOP_TIMEOUT, transaction, "stop-timeout");
            this.writeOptional(writer, Attribute.MODE, transaction, "mode");
            this.writeOptional(writer, Attribute.LOCKING, transaction, "locking");
            this.writeOptional(writer, Attribute.NOTIFICATIONS, transaction, "notifications");
            writer.writeEndElement();
        }
        if ((memory = cache.get("memory")).isDefined()) {
            writer.writeStartElement(Element.MEMORY.getLocalName());
            ModelNode memoryValues = memory.get("BINARY");
            if (memoryValues.isDefined()) {
                writer.writeStartElement(Element.BINARY.getLocalName());
                this.writeOptional(writer, Attribute.SIZE, memoryValues, "size");
                this.writeOptional(writer, Attribute.STRATEGY, memoryValues, "strategy");
                this.writeOptional(writer, Attribute.EVICTION, memoryValues, "eviction");
                writer.writeEndElement();
            } else {
                memoryValues = memory.get("OBJECT");
                if (memoryValues.isDefined()) {
                    writer.writeStartElement(Element.OBJECT.getLocalName());
                    this.writeOptional(writer, Attribute.SIZE, memoryValues, "size");
                    this.writeOptional(writer, Attribute.STRATEGY, memoryValues, "strategy");
                    writer.writeEndElement();
                } else {
                    memoryValues = memory.get("OFF-HEAP");
                    if (memoryValues.isDefined()) {
                        writer.writeStartElement(Element.OFF_HEAP.getLocalName());
                        this.writeOptional(writer, Attribute.SIZE, memoryValues, "size");
                        this.writeOptional(writer, Attribute.STRATEGY, memoryValues, "strategy");
                        this.writeOptional(writer, Attribute.EVICTION, memoryValues, "eviction");
                        this.writeOptional(writer, Attribute.ADDRESS_COUNT, memoryValues, "address-count");
                        writer.writeEndElement();
                    }
                }
            }
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            writer.writeStartElement(Element.EXPIRATION.getLocalName());
            ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
            this.writeOptional(writer, Attribute.MAX_IDLE, expiration, "max-idle");
            this.writeOptional(writer, Attribute.LIFESPAN, expiration, "lifespan");
            this.writeOptional(writer, Attribute.INTERVAL, expiration, "interval");
            writer.writeEndElement();
        }
        if (cache.get("compatibility").isDefined()) {
            ModelNode compatibility = cache.get(new String[]{"compatibility", "COMPATIBILITY"});
            writer.writeStartElement(Element.COMPATIBILITY.getLocalName());
            CompatibilityConfigurationResource.ENABLED.marshallAsAttribute(compatibility, (XMLStreamWriter)writer);
            CompatibilityConfigurationResource.MARSHALLER.marshallAsAttribute(compatibility, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined("security")) {
            writer.writeStartElement(Element.SECURITY.getLocalName());
            ModelNode security = cache.get(new String[]{"security", "SECURITY"});
            if (security.hasDefined("authorization")) {
                writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
                ModelNode authorization = security.get(new String[]{"authorization", "AUTHORIZATION"});
                CacheAuthorizationConfigurationResource.ENABLED.marshallAsAttribute(authorization, (XMLStreamWriter)writer);
                this.writeListAsAttribute(writer, Attribute.ROLES, authorization, "roles");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        ModelNode persistence = cache.get(new String[]{"persistence", "PERSISTENCE"});
        String[] attrStrings = (String[])Arrays.stream(PersistenceConfigurationResource.ATTRIBUTES).map(AttributeDefinition::getName).toArray(String[]::new);
        boolean attrOrElementExists = Stream.of(attrStrings, PersistenceConfigurationResource.LOADER_KEYS, PersistenceConfigurationResource.STORE_KEYS).flatMap(Arrays::stream).anyMatch(arg_0 -> ((ModelNode)persistence).hasDefined(arg_0));
        if (attrOrElementExists) {
            writer.writeStartElement("persistence");
            this.writeOptional(writer, Attribute.AVAILABILITY_INTERVAL, persistence, "availability-interval");
            this.writeOptional(writer, Attribute.CONNECTION_ATTEMPTS, persistence, "connection-attempts");
            this.writeOptional(writer, Attribute.CONNECTION_INTERVAL, persistence, "connection-interval");
            this.writeOptional(writer, Attribute.PASSIVATION, persistence, "passivation");
            this.writePersistence(writer, persistence);
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"indexing", "INDEXING"}).isDefined()) {
            ModelNode indexing = cache.get(new String[]{"indexing", "INDEXING"});
            writer.writeStartElement(Element.INDEXING.getLocalName());
            IndexingConfigurationResource.INDEXING.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
            IndexingConfigurationResource.INDEXING_AUTO_CONFIG.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
            if (indexing.get("key-transformers").isDefined()) {
                writer.writeStartElement(Element.KEY_TRANSFORMERS.getLocalName());
                IndexingConfigurationResource.KEY_TRANSFORMERS.marshallAsElement(indexing, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            if (indexing.get("indexed-entities").isDefined()) {
                writer.writeStartElement(Element.INDEXED_ENTITIES.getLocalName());
                IndexingConfigurationResource.INDEXED_ENTITIES.marshallAsElement(indexing, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            IndexingConfigurationResource.INDEXING_PROPERTIES.marshallAsElement(indexing, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
            writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
            this.writeOptional(writer, Attribute.AWAIT_INITIAL_TRANSFER, stateTransfer, "await-initial-transfer");
            this.writeOptional(writer, Attribute.ENABLED, stateTransfer, "enabled");
            this.writeOptional(writer, Attribute.TIMEOUT, stateTransfer, "timeout");
            this.writeOptional(writer, Attribute.CHUNK_SIZE, stateTransfer, "chunk-size");
            writer.writeEndElement();
        }
        if (cache.get(new String[]{"partition-handling", "PARTITION_HANDLING"}).isDefined()) {
            ModelNode partitionHandling = cache.get(new String[]{"partition-handling", "PARTITION_HANDLING"});
            writer.writeStartElement(Element.PARTITION_HANDLING.getLocalName());
            this.writeOptional(writer, Attribute.WHEN_SPLIT, partitionHandling, "when-split");
            this.writeOptional(writer, Attribute.MERGE_POLICY, partitionHandling, "merge-policy");
            writer.writeEndElement();
        }
    }

    private void writePersistence(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        ModelNode store;
        Object name;
        ModelNode loader;
        if (cache.get("loader").isDefined()) {
            for (Property clusterLoaderEntry : cache.get("loader").asPropertyList()) {
                loader = clusterLoaderEntry.getValue();
                writer.writeStartElement(Element.LOADER.getLocalName());
                name = new ModelNode();
                name.get("name").set(clusterLoaderEntry.getName());
                LoaderConfigurationResource.NAME.marshallAsAttribute((ModelNode)name, false, (XMLStreamWriter)writer);
                this.writeRequired(writer, Attribute.CLASS, loader, "class");
                this.writeLoaderAttributes(writer, loader);
                this.writeStoreProperties(writer, loader);
                writer.writeEndElement();
            }
        }
        if (cache.get("cluster-loader").isDefined()) {
            for (Property clusterLoaderEntry : cache.get("cluster-loader").asPropertyList()) {
                loader = clusterLoaderEntry.getValue();
                writer.writeStartElement(Element.CLUSTER_LOADER.getLocalName());
                name = new ModelNode();
                name.get("name").set(clusterLoaderEntry.getName());
                ClusterLoaderConfigurationResource.NAME.marshallAsAttribute((ModelNode)name, false, (XMLStreamWriter)writer);
                this.writeOptional(writer, Attribute.REMOTE_TIMEOUT, loader, "remote-timeout");
                this.writeLoaderAttributes(writer, loader);
                this.writeStoreProperties(writer, loader);
                writer.writeEndElement();
            }
        }
        if (cache.get("store").isDefined()) {
            for (Property storeEntry : cache.get("store").asPropertyList()) {
                store = storeEntry.getValue();
                writer.writeStartElement(Element.STORE.getLocalName());
                this.writeRequired(writer, Attribute.CLASS, store, "class");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                writer.writeEndElement();
            }
        }
        if (cache.get("file-store").isDefined()) {
            for (Property fileStoreEntry : cache.get("file-store").asPropertyList()) {
                store = fileStoreEntry.getValue();
                writer.writeStartElement(Element.FILE_STORE.getLocalName());
                this.writeOptional(writer, Attribute.MAX_ENTRIES, store, "max-entries");
                this.writeOptional(writer, Attribute.RELATIVE_TO, store, "relative-to");
                this.writeOptional(writer, Attribute.PATH, store, "path");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                writer.writeEndElement();
            }
        }
        if (cache.get("string-keyed-jdbc-store").isDefined()) {
            for (Property stringKeyedJDBCStoreEntry : cache.get("string-keyed-jdbc-store").asPropertyList()) {
                store = stringKeyedJDBCStoreEntry.getValue();
                writer.writeStartElement(Element.STRING_KEYED_JDBC_STORE.getLocalName());
                this.writeJdbcStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                this.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
                writer.writeEndElement();
            }
        }
        if (cache.get("rocksdb-store").isDefined()) {
            for (Property rocksDbStoreEntry : cache.get("rocksdb-store").asPropertyList()) {
                store = rocksDbStoreEntry.getValue();
                writer.writeStartElement(Element.ROCKSDB_STORE.getLocalName());
                this.writeOptional(writer, Attribute.RELATIVE_TO, store, "relative-to");
                this.writeOptional(writer, Attribute.PATH, store, "path");
                this.writeOptional(writer, Attribute.BLOCK_SIZE, store, "block-size");
                this.writeOptional(writer, Attribute.CACHE_SIZE, store, "cache-size");
                this.writeOptional(writer, Attribute.CLEAR_THRESHOLD, store, "clear-threshold");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeRocksDBStoreExpiration(writer, store);
                this.writeRocksDBStoreCompression(writer, store);
                this.writeStoreProperties(writer, store);
                writer.writeEndElement();
            }
        }
        if (cache.get("remote-store").isDefined()) {
            for (Property remoteStoreEntry : cache.get("remote-store").asPropertyList()) {
                store = remoteStoreEntry.getValue();
                writer.writeStartElement(Element.REMOTE_STORE.getLocalName());
                this.writeOptional(writer, Attribute.CACHE, store, "cache");
                this.writeOptional(writer, Attribute.HOTROD_WRAPPING, store, "hotrod-wrapping");
                this.writeOptional(writer, Attribute.RAW_VALUES, store, "raw-values");
                this.writeOptional(writer, Attribute.SOCKET_TIMEOUT, store, "socket-timeout");
                this.writeOptional(writer, Attribute.TCP_NO_DELAY, store, "tcp-no-delay");
                this.writeOptional(writer, Attribute.PROTOCOL_VERSION, store, "protocol-version");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                for (Object remoteServer : store.require("remote-servers").asList()) {
                    writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                    writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING.getLocalName(), remoteServer.get("outbound-socket-binding").asString());
                    writer.writeEndElement();
                }
                if (store.get(new String[]{"authentication", "AUTHENTICATION"}).isDefined()) {
                    ModelNode authentication = store.get(new String[]{"authentication", "AUTHENTICATION"});
                    writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
                    switch (authentication.get("mechanism").asString()) {
                        case "PLAIN": {
                            writer.writeStartElement(Element.PLAIN.getLocalName());
                            this.writeRequired(writer, Attribute.USERNAME, authentication, "username");
                            this.writeRequired(writer, Attribute.PASSWORD, authentication, "password");
                            writer.writeEndElement();
                            break;
                        }
                        case "DIGEST-MD5": {
                            writer.writeStartElement(Element.DIGEST.getLocalName());
                            this.writeRequired(writer, Attribute.USERNAME, authentication, "username");
                            this.writeRequired(writer, Attribute.PASSWORD, authentication, "password");
                            this.writeRequired(writer, Attribute.REALM, authentication, "realm");
                            this.writeOptional(writer, Attribute.SERVER_NAME, authentication, "server-name");
                            writer.writeEndElement();
                            break;
                        }
                        case "EXTERNAL": {
                            writer.writeEmptyElement(Element.EXTERNAL.getLocalName());
                        }
                    }
                    writer.writeEndElement();
                }
                if (store.get(new String[]{"encryption", "ENCRYPTION"}).isDefined()) {
                    ModelNode encryption = store.get(new String[]{"encryption", "ENCRYPTION"});
                    writer.writeStartElement(Element.ENCRYPTION.getLocalName());
                    this.writeRequired(writer, Attribute.SECURITY_REALM, encryption, "security-realm");
                    this.writeOptional(writer, Attribute.SNI_HOSTNAME, encryption, "sni-hostname");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        if (cache.get("rest-store").isDefined()) {
            for (Property restStoreEntry : cache.get("rest-store").asPropertyList()) {
                store = restStoreEntry.getValue();
                writer.writeStartElement(Element.REST_STORE.getLocalName());
                this.writeOptional(writer, Attribute.CACHE_NAME, store, "cache-name");
                this.writeStoreAttributes(writer, store);
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                for (Object remoteServer : store.require("remote-servers").asList()) {
                    writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                    writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING.getLocalName(), remoteServer.get("outbound-socket-binding").asString());
                    writer.writeEndElement();
                }
                if (store.hasDefined("connection-pool")) {
                    ModelNode pool = store.get("connection-pool");
                    writer.writeStartElement(Element.CONNECTION_POOL.getLocalName());
                    this.writeOptional(writer, Attribute.CONNECTION_TIMEOUT, pool, "connection-timeout");
                    this.writeOptional(writer, Attribute.MAX_CONNECTIONS_PER_HOST, pool, "max-connections-per-host");
                    this.writeOptional(writer, Attribute.MAX_TOTAL_CONNECTIONS, pool, "max-total-connections");
                    this.writeOptional(writer, Attribute.BUFFER_SIZE, pool, "buffer-size");
                    this.writeOptional(writer, Attribute.SOCKET_TIMEOUT, pool, "socket-timeout");
                    this.writeOptional(writer, Attribute.TCP_NO_DELAY, pool, "tcp-no-delay");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        if (cache.get("soft-index-file-store").isDefined()) {
            for (Property softIndexEntry : cache.get("soft-index-file-store").asPropertyList()) {
                store = softIndexEntry.getValue();
                writer.writeStartElement(Element.SOFT_INDEX_FILE_STORE.getLocalName());
                this.writeOptional(writer, Attribute.COMPACTION_THRESHOLD, store, "compaction-threshold");
                this.writeOptional(writer, Attribute.OPEN_FILES_LIMIT, store, "open-files-limit");
                this.writeStoreAttributes(writer, store);
                if (store.hasDefined("data")) {
                    ModelNode data = store.get(SoftIndexConfigurationResource.DATA_PATH.getKeyValuePair());
                    writer.writeStartElement(Element.DATA.getLocalName());
                    this.writeOptional(writer, Attribute.PATH, data, "path");
                    this.writeOptional(writer, Attribute.MAX_FILE_SIZE, data, "max-file-size");
                    this.writeOptional(writer, Attribute.SYNC_WRITES, data, "sync-writes");
                    writer.writeEndElement();
                }
                if (store.hasDefined("index")) {
                    ModelNode index = store.get(SoftIndexConfigurationResource.INDEX_PATH.getKeyValuePair());
                    writer.writeStartElement(Element.INDEX.getLocalName());
                    this.writeOptional(writer, Attribute.PATH, index, "path");
                    this.writeOptional(writer, Attribute.MAX_NODE_SIZE, index, "max-node-size");
                    this.writeOptional(writer, Attribute.MIN_NODE_SIZE, index, "min-node-size");
                    this.writeOptional(writer, Attribute.MAX_QUEUE_LENGTH, index, "max-queue-length");
                    this.writeOptional(writer, Attribute.SEGMENTS, index, "segments");
                    writer.writeEndElement();
                }
                this.writeStoreWriteBehind(writer, store);
                this.writeStoreProperties(writer, store);
                writer.writeEndElement();
            }
        }
    }

    private void writeListAsAttribute(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode node, String key) throws XMLStreamException {
        if (node.hasDefined(key)) {
            StringBuilder result = new StringBuilder();
            ModelNode list = node.get(key);
            if (list.isDefined() && list.getType() == ModelType.LIST) {
                List nodeList = list.asList();
                for (int i = 0; i < nodeList.size(); ++i) {
                    result.append(((ModelNode)nodeList.get(i)).asString());
                    if (i >= nodeList.size() - 1) continue;
                    result.append(" ");
                }
                writer.writeAttribute(attribute.getLocalName(), result.toString());
            }
        }
    }

    private void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, ModelNode store, String key) throws XMLStreamException {
        if (store.hasDefined(key)) {
            ModelNode table = store.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.PREFIX, table, "prefix");
            this.writeOptional(writer, Attribute.BATCH_SIZE, table, "batch-size");
            this.writeOptional(writer, Attribute.FETCH_SIZE, table, "fetch-size");
            this.writeOptional(writer, Attribute.CREATE_ON_START, table, "create-on-start");
            this.writeOptional(writer, Attribute.DROP_ON_EXIT, table, "drop-on-exit");
            this.writeJDBCStoreColumn(writer, Element.ID_COLUMN, table, "id-column");
            this.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, table, "data-column");
            this.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, table, "timestamp-column");
            writer.writeEndElement();
        }
    }

    private void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, ModelNode table, String key) throws XMLStreamException {
        if (table.hasDefined(key)) {
            ModelNode column = table.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.NAME, column, "name");
            this.writeOptional(writer, Attribute.TYPE, column, "type");
            writer.writeEndElement();
        }
    }

    private void writeLoaderAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeOptional(writer, Attribute.SHARED, store, "shared");
        this.writeOptional(writer, Attribute.PRELOAD, store, "preload");
    }

    private void writeJdbcStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeRequired(writer, Attribute.DATASOURCE, store, "datasource");
        this.writeOptional(writer, Attribute.DB_MAJOR_VERSION, store, "db-major-version");
        this.writeOptional(writer, Attribute.DB_MINOR_VERSION, store, "db-minor-version");
        this.writeOptional(writer, Attribute.DIALECT, store, "dialect");
        this.writeStoreAttributes(writer, store);
    }

    private void writeStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeOptional(writer, Attribute.NAME, store, "name");
        this.writeOptional(writer, Attribute.SHARED, store, "shared");
        this.writeOptional(writer, Attribute.PRELOAD, store, "preload");
        this.writeOptional(writer, Attribute.FETCH_STATE, store, "fetch-state");
        this.writeOptional(writer, Attribute.PURGE, store, "purge");
        this.writeOptional(writer, Attribute.READ_ONLY, store, "read-only");
        this.writeOptional(writer, Attribute.MAX_BATCH_SIZE, store, "max-batch-size");
    }

    private void writeStoreWriteBehind(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined()) {
            ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
            writer.writeStartElement(Element.WRITE_BEHIND.getLocalName());
            this.writeOptional(writer, Attribute.MODIFICATION_QUEUE_SIZE, writeBehind, "modification-queue-size");
            this.writeOptional(writer, Attribute.THREAD_POOL_SIZE, writeBehind, "thread-pool-size");
            writer.writeEndElement();
        }
    }

    private void writeStoreProperties(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private void writeRocksDBStoreExpiration(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = store.get(new String[]{"expiration", "EXPIRATION"});
            writer.writeStartElement(Element.EXPIRATION.getLocalName());
            this.writeOptional(writer, Attribute.PATH, expiration, "path");
            this.writeOptional(writer, Attribute.RELATIVE_TO, expiration, "relative-to");
            this.writeOptional(writer, Attribute.QUEUE_SIZE, expiration, "queue-size");
            writer.writeEndElement();
        }
    }

    private void writeRocksDBStoreCompression(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"compression", "COMPRESSION"}).isDefined()) {
            ModelNode compression = store.get(new String[]{"compression", "COMPRESSION"});
            writer.writeStartElement(Element.COMPRESSION.getLocalName());
            this.writeOptional(writer, Attribute.TYPE, compression, "type");
            writer.writeEndElement();
        }
    }

    private void writeOptional(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        if (model.hasDefined(key)) {
            writer.writeAttribute(attribute.getLocalName(), model.get(key).asString());
        }
    }

    private void writeRequired(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), model.require(key).asString());
    }

    private static boolean hasDefined(ModelNode model, Iterable<? extends AttributeDefinition> attributes) {
        for (AttributeDefinition attributeDefinition : attributes) {
            if (!model.hasDefined(attributeDefinition.getName())) continue;
            return true;
        }
        return false;
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Iterable<? extends AttributeDefinition> attributes) throws XMLStreamException {
        for (AttributeDefinition attributeDefinition : attributes) {
            InfinispanSubsystemXMLWriter.writeAttribute(writer, model, attributeDefinition);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getMarshaller().marshallAsAttribute(attribute, model, true, (XMLStreamWriter)writer);
    }
}

