/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultEmbeddedCacheManagerTest {
    private final EmbeddedCacheManager manager = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
    private final EmbeddedCacheManager subject = new DefaultCacheContainer(this.manager, "default");

    @After
    public void cleanup() {
        Mockito.reset((Object[])new EmbeddedCacheManager[]{this.manager});
    }

    @Test
    public void getDefaultCache() {
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        Mockito.when((Object)this.manager.getCache("default", true)).thenReturn((Object)cache);
        Mockito.when((Object)cache.getAdvancedCache()).thenReturn((Object)cache);
        Cache result = this.subject.getCache();
        Assert.assertNotSame((Object)cache, (Object)result);
        Assert.assertEquals((Object)result, (Object)cache);
        Assert.assertSame((Object)this.subject, (Object)result.getCacheManager());
    }

    @Test
    public void getCache() {
        AdvancedCache defaultCache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        AdvancedCache otherCache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        Mockito.when((Object)this.manager.getCache("default", true)).thenReturn((Object)defaultCache);
        Mockito.when((Object)this.manager.getCache("other", true)).thenReturn((Object)otherCache);
        Mockito.when((Object)defaultCache.getAdvancedCache()).thenReturn((Object)defaultCache);
        Mockito.when((Object)otherCache.getAdvancedCache()).thenReturn((Object)otherCache);
        Cache result = this.subject.getCache("default");
        Assert.assertNotSame((Object)defaultCache, (Object)result);
        Assert.assertEquals((Object)result, (Object)defaultCache);
        Assert.assertSame((Object)this.subject, (Object)result.getCacheManager());
        result = this.subject.getCache("other");
        Assert.assertNotSame((Object)otherCache, (Object)result);
        Assert.assertEquals((Object)result, (Object)otherCache);
        Assert.assertSame((Object)this.subject, (Object)result.getCacheManager());
        result = this.subject.getCache();
        Assert.assertNotSame((Object)defaultCache, (Object)result);
        Assert.assertEquals((Object)result, (Object)defaultCache);
        Assert.assertSame((Object)this.subject, (Object)result.getCacheManager());
        result = this.subject.getCache(null);
        Assert.assertNotSame((Object)defaultCache, (Object)result);
        Assert.assertEquals((Object)result, (Object)defaultCache);
        Assert.assertSame((Object)this.subject, (Object)result.getCacheManager());
    }

    @Test
    public void start() {
        this.subject.start();
        ((EmbeddedCacheManager)Mockito.verify((Object)this.manager)).start();
    }

    @Test
    public void stop() {
        this.subject.stop();
        ((EmbeddedCacheManager)Mockito.verify((Object)this.manager)).stop();
    }

    @Test
    public void addListener() {
        Object listener = new Object();
        this.subject.addListener(listener);
        ((EmbeddedCacheManager)Mockito.verify((Object)this.manager)).addListener(listener);
    }

    @Test
    public void removeListener() {
        Object listener = new Object();
        this.subject.removeListener(listener);
        ((EmbeddedCacheManager)Mockito.verify((Object)this.manager)).removeListener(listener);
    }

    @Test
    public void getListeners() {
        Set<Object> expected = Collections.singleton(new Object());
        Mockito.when((Object)this.manager.getListeners()).thenReturn(expected);
        Set result = this.subject.getListeners();
        Assert.assertSame(expected, (Object)result);
    }

    @Test
    public void defineConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Configuration defaultConfig = builder.build();
        Configuration otherConfig = builder.build();
        Mockito.when((Object)this.manager.defineConfiguration("default", defaultConfig)).thenReturn((Object)defaultConfig);
        Mockito.when((Object)this.manager.defineConfiguration("other", otherConfig)).thenReturn((Object)otherConfig);
        Configuration result = this.subject.defineConfiguration("default", defaultConfig);
        Assert.assertSame((Object)defaultConfig, (Object)result);
        result = this.subject.defineConfiguration("other", otherConfig);
        Assert.assertSame((Object)otherConfig, (Object)result);
    }

    @Test
    public void getClusterName() {
        String expected = "cluster";
        Mockito.when((Object)this.manager.getClusterName()).thenReturn((Object)expected);
        String result = this.subject.getClusterName();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getMembers() {
        List<Address> expected = Collections.singletonList((Address)Mockito.mock(Address.class));
        Mockito.when((Object)this.manager.getMembers()).thenReturn(expected);
        List result = this.subject.getMembers();
        Assert.assertSame(expected, (Object)result);
    }

    @Test
    public void getAddress() {
        Address expected = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)this.manager.getAddress()).thenReturn((Object)expected);
        Address result = this.subject.getAddress();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getCoordinator() {
        Address expected = (Address)Mockito.mock(Address.class);
        Mockito.when((Object)this.manager.getCoordinator()).thenReturn((Object)expected);
        Address result = this.subject.getCoordinator();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getStatus() {
        ComponentStatus expected = ComponentStatus.INITIALIZING;
        Mockito.when((Object)this.manager.getStatus()).thenReturn((Object)expected);
        ComponentStatus result = this.subject.getStatus();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getCacheManagerConfiguration() {
        GlobalConfiguration global = new GlobalConfigurationBuilder().build();
        Mockito.when((Object)this.manager.getCacheManagerConfiguration()).thenReturn((Object)global);
        GlobalConfiguration result = this.subject.getCacheManagerConfiguration();
        Assert.assertSame((Object)global, (Object)result);
    }

    @Test
    public void getDefaultCacheConfiguration() {
        Configuration config = new ConfigurationBuilder().build();
        Mockito.when((Object)this.manager.getDefaultCacheConfiguration()).thenReturn((Object)config);
        Configuration result = this.subject.getDefaultCacheConfiguration();
        Assert.assertSame((Object)config, (Object)result);
    }

    @Test
    public void getCacheConfiguration() {
        Configuration config = new ConfigurationBuilder().build();
        Mockito.when((Object)this.manager.getCacheConfiguration("cache")).thenReturn((Object)config);
        Configuration result = this.subject.getCacheConfiguration("cache");
        Assert.assertSame((Object)config, (Object)result);
    }

    @Test
    public void getCacheNames() {
        Set<String> caches = Collections.singleton("other");
        Mockito.when((Object)this.manager.getCacheNames()).thenReturn(caches);
        Set result = this.subject.getCacheNames();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("other"));
        Assert.assertTrue((boolean)result.contains("default"));
    }

    @Test
    public void isRunning() {
        Mockito.when((Object)this.manager.isRunning("other")).thenReturn((Object)false);
        Mockito.when((Object)this.manager.isRunning("default")).thenReturn((Object)true);
        boolean result = this.subject.isRunning("other");
        Assert.assertFalse((boolean)result);
        result = this.subject.isRunning("default");
        Assert.assertTrue((boolean)result);
        result = this.subject.isDefaultRunning();
        Assert.assertTrue((boolean)result);
        result = this.subject.isRunning(null);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void isDefaultRunning() {
        Mockito.when((Object)this.manager.isRunning("default")).thenReturn((Object)true);
        boolean result = this.subject.isDefaultRunning();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void startCaches() {
        Mockito.when((Object)this.manager.startCaches(new String[]{"other", "default"})).thenReturn((Object)this.manager);
        EmbeddedCacheManager result = this.subject.startCaches(new String[]{"other", "default"});
        Assert.assertSame((Object)this.subject, (Object)result);
    }
}

