/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class CacheConfigurationTestCase
extends AbstractSubsystemTest {
    public CacheConfigurationTestCase() {
        super("datagrid-infinispan", (Extension)new InfinispanExtension());
    }

    @Test
    public void testConfigurationAttrIsPreserved() throws XMLStreamException, IOException {
        ArrayList<ModelNode> expected = new ArrayList<ModelNode>();
        PathAddress subsystemAddr = PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH});
        expected.add(Util.createAddOperation((PathAddress)subsystemAddr));
        PathAddress containerAddr = subsystemAddr.append("cache-container", "local");
        PathAddress jdbcCacheAddr = containerAddr.append("local-cache", "jdbcCache");
        ModelNode addJdbcCacheOp = Util.createAddOperation((PathAddress)jdbcCacheAddr);
        addJdbcCacheOp.get("configuration").set("jdbc-cache-config");
        List modelNodes = this.parse(this.readResource("cache-configuration-test.xml"));
        Assert.assertTrue((String)String.format("expected %s in list of parsed model nodes", addJdbcCacheOp), (boolean)modelNodes.contains(addJdbcCacheOp));
    }
}

