/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemDependenciesInitialization;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.model.test.ModelTestModelControllerService;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class OperationTestCaseBase
extends AbstractSubsystemTest {
    static final ModelVersion VERSION = InfinispanSchema.CURRENT.getVersion();
    static final String SUBSYSTEM_XML_FILE = String.format("subsystem-infinispan_%d_%d.xml", VERSION.getMajor(), VERSION.getMinor());

    public OperationTestCaseBase() {
        super("datagrid-infinispan", (Extension)new InfinispanExtension());
    }

    KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(this.createAdditionalInitialization());
    }

    AdditionalInitialization createAdditionalInitialization() {
        return new InfinispanSubsystemDependenciesInitialization();
    }

    protected static ModelNode getCacheContainerAddOperation(String containerName) {
        PathAddress containerAddr = OperationTestCaseBase.getCacheContainerAddress(containerName);
        ModelNode addOp = Util.createAddOperation((PathAddress)containerAddr);
        addOp.get("default-cache").set("default");
        return addOp;
    }

    protected static ModelNode getCacheContainerReadOperation(String containerName, String name) {
        PathAddress transportAddress = OperationTestCaseBase.getCacheContainerAddress(containerName);
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-attribute");
        readOp.get("address").set(transportAddress.toModelNode());
        readOp.get("name").set(name);
        return readOp;
    }

    protected static ModelNode getCacheContainerWriteOperation(String containerName, String name, String value) {
        PathAddress cacheAddress = OperationTestCaseBase.getCacheContainerAddress(containerName);
        return Util.getWriteAttributeOperation((PathAddress)cacheAddress, (String)name, (ModelNode)new ModelNode().set(value));
    }

    protected static ModelNode getCacheContainerRemoveOperation(String containerName) {
        PathAddress containerAddr = OperationTestCaseBase.getCacheContainerAddress(containerName);
        return Util.createRemoveOperation((PathAddress)containerAddr);
    }

    protected static ModelNode getCacheAddOperation(String containerName, String cacheType, String cacheName) {
        PathAddress cacheAddr = OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName);
        ModelNode addOp = Util.createAddOperation((PathAddress)cacheAddr);
        addOp.get("jndi-name").set("java:/fred/was/here");
        return addOp;
    }

    protected static ModelNode getCacheConfigurationReadOperation(String containerName, String cacheType, String cacheName, String name) {
        PathAddress cacheAddress = OperationTestCaseBase.getCacheConfigurationAddress(containerName, cacheType, cacheName);
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-attribute");
        readOp.get("address").set(cacheAddress.toModelNode());
        readOp.get("name").set(name);
        return readOp;
    }

    protected static ModelNode getCacheConfigurationWriteOperation(String containerName, String cacheType, String cacheName, String name, String value) {
        PathAddress cacheAddress = OperationTestCaseBase.getCacheConfigurationAddress(containerName, cacheType, cacheName);
        return Util.getWriteAttributeOperation((PathAddress)cacheAddress, (String)name, (ModelNode)new ModelNode().set(value));
    }

    protected static ModelNode getCacheRemoveOperation(String containerName, String cacheType, String cacheName) {
        PathAddress cacheAddr = OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName);
        return Util.createRemoveOperation((PathAddress)cacheAddr);
    }

    protected static ModelNode getStringKeyedJDBCCacheStoreReadOperation(String containerName, String cacheType, String cacheName, String name) {
        PathAddress cacheAddress = OperationTestCaseBase.getStringKeyedJDBCCacheStoreAddress(containerName, cacheType, cacheName);
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-attribute");
        readOp.get("address").set(cacheAddress.toModelNode());
        readOp.get("name").set(name);
        return readOp;
    }

    protected static ModelNode getStringKeyedJDBCCacheStoreWriteOperation(String containerName, String cacheType, String cacheName, String name, String value) {
        PathAddress cacheStoreAddress = OperationTestCaseBase.getStringKeyedJDBCCacheStoreAddress(containerName, cacheType, cacheName);
        return Util.getWriteAttributeOperation((PathAddress)cacheStoreAddress, (String)name, (ModelNode)new ModelNode().set(value));
    }

    protected static PathAddress getStringKeyedJDBCCacheStoreAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheConfigurationAddress(containerName, cacheType, cacheName).append("string-keyed-jdbc-store", "jdbc-store");
    }

    protected static PathAddress getCacheContainerAddress(String containerName) {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH}).append("cache-container", containerName);
    }

    protected static PathAddress getCacheAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheContainerAddress(containerName).append(cacheType, cacheName);
    }

    protected static PathAddress getCacheConfigurationAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheContainerAddress(containerName).append("configurations", "CONFIGURATIONS").append(cacheType, cacheName);
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource(SUBSYSTEM_XML_FILE);
    }

    protected void assertServerState(KernelServices services, String expected) {
        ModelTestModelControllerService controllerService = (ModelTestModelControllerService)OperationTestCaseBase.extractField(services, "controllerService");
        ControlledProcessState processState = (ControlledProcessState)OperationTestCaseBase.extractField(controllerService, "processState");
        Assert.assertEquals((Object)expected, (Object)processState.getState().toString());
    }

    protected void executeAndAssertOutcome(KernelServices service, ModelNode operation, String outcome) {
        ModelNode result = service.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.asString(), (Object)outcome, (Object)result.get("outcome").asString());
    }

    public static <T> T extractField(Object target, String fieldName) {
        return (T)OperationTestCaseBase.extractField(target.getClass(), target, fieldName);
    }

    public static Object extractField(Class type, Object target, String fieldName) {
        while (true) {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(target);
            }
            catch (Exception e) {
                if (type.equals(Object.class)) {
                    e.printStackTrace();
                    return null;
                }
                type = type.getSuperclass();
                continue;
            }
            break;
        }
    }
}

