/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.InputStream;
import org.jboss.as.clustering.infinispan.subsystem.OperationTestCaseBase;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class OperationsTestCase
extends OperationTestCaseBase {
    static final ModelNode readCacheContainerDefaultCacheOp = OperationsTestCase.getCacheContainerReadOperation("maximal", "default-cache");
    static final ModelNode writeCacheContainerDefaultCacheOp = OperationsTestCase.getCacheContainerWriteOperation("maximal", "default-cache", "new-default-cache");
    static final ModelNode readLocalCacheBatchingOp = OperationsTestCase.getCacheConfigurationReadOperation("maximal", "local-cache-configuration", "local", "batching");
    static final ModelNode writeLocalCacheBatchingOp = OperationsTestCase.getCacheConfigurationWriteOperation("maximal", "local-cache-configuration", "local", "batching", "false");
    static final ModelNode readDistCacheStringJDBCStoreDatastoreOp = OperationsTestCase.getStringKeyedJDBCCacheStoreReadOperation("maximal", "distributed-cache-configuration", "dist", "datasource");
    static final ModelNode writeDistCacheStringJDBCStoreDatastoreOp = OperationsTestCase.getStringKeyedJDBCCacheStoreWriteOperation("maximal", "distributed-cache-configuration", "dist", "datasource", "new-datasource");
    static final ModelNode readDistCacheStringJDBCStoreStringKeyedTableOp = OperationsTestCase.getStringKeyedJDBCCacheStoreReadOperation("maximal", "distributed-cache-configuration", "dist", "string-keyed-table");

    @Test
    public void testCacheContainerReadWriteOperation() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        ModelNode result = servicesA.executeOperation(readCacheContainerDefaultCacheOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"local", (Object)result.get("result").asString());
        result = servicesA.executeOperation(writeCacheContainerDefaultCacheOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = servicesA.executeOperation(readCacheContainerDefaultCacheOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-default-cache", (Object)result.get("result").asString());
    }

    @Test
    public void testLocalCacheReadWriteOperation() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        ModelNode result = servicesA.executeOperation(readLocalCacheBatchingOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = servicesA.executeOperation(writeLocalCacheBatchingOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = servicesA.executeOperation(readLocalCacheBatchingOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        this.assertServerState(servicesA, "running");
    }

    @Test
    public void testDistributedCacheStringJDBCStoreReadWriteOperation() throws Exception {
        ModelNode stringKeyedTable = this.createStringKeyedTable();
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        ModelNode result = servicesA.executeOperation(readDistCacheStringJDBCStoreDatastoreOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"java:jboss/datasources/JdbcDS", (Object)result.get("result").asString());
        result = servicesA.executeOperation(writeDistCacheStringJDBCStoreDatastoreOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = servicesA.executeOperation(readDistCacheStringJDBCStoreDatastoreOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-datasource", (Object)result.get("result").asString());
        result = servicesA.executeOperation(readDistCacheStringJDBCStoreStringKeyedTableOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)stringKeyedTable.asString(), (Object)result.get("result").asString());
        this.assertServerState(servicesA, "running");
    }

    private ModelNode createStringKeyedTable() {
        ModelNode stringKeyedTable = new ModelNode().setEmptyObject();
        stringKeyedTable.get("prefix").set("ISPN_MC_SK");
        stringKeyedTable.get("create-on-start").set(true);
        stringKeyedTable.get("drop-on-exit").set(true);
        ModelNode idColumn = stringKeyedTable.get("id-column").setEmptyObject();
        idColumn.get("name").set("id");
        idColumn.get("type").set("VARCHAR");
        ModelNode dataColumn = stringKeyedTable.get("data-column").setEmptyObject();
        dataColumn.get("name").set("datum");
        dataColumn.get("type").set("BINARY");
        ModelNode timestampColumn = stringKeyedTable.get("timestamp-column").setEmptyObject();
        timestampColumn.get("name").set("version");
        timestampColumn.get("type").set("BIGINT");
        return stringKeyedTable;
    }
}

