/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Version;
import org.infinispan.server.commons.controller.Operations;
import org.infinispan.server.commons.subsystem.ClusteringSubsystemTest;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemInitialization;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemRootResource;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.AdditionalParsers;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SubsystemParsingTestCase
extends ClusteringSubsystemTest {
    private final int expectedOperationCount;
    private final String xsdPath;
    private final String[] templates;

    public SubsystemParsingTestCase(Path xmlPath, Properties properties, String name) {
        super("datagrid-infinispan", (Extension)new InfinispanExtension(), xmlPath.getFileName().toString());
        this.expectedOperationCount = Integer.parseInt(properties.getProperty("expected.operations.count"));
        this.xsdPath = properties.getProperty("xsd.path");
        this.templates = null;
    }

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> data() throws Exception {
        URL configDir = Thread.currentThread().getContextClassLoader().getResource("org/jboss/as/clustering/infinispan/subsystem");
        List paths = Files.list(Paths.get(configDir.toURI())).filter(path -> path.getFileName().toString().matches("^subsystem-infinispan_[0-9]+_[0-9]+.xml$")).collect(Collectors.toList());
        boolean hasCurrentSchema = false;
        String currentSchema = "subsystem-infinispan_" + Version.getSchemaVersion().replaceAll("\\.", "_") + ".xml";
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (int i = 0; i < paths.size(); ++i) {
            Path xmlPath = (Path)paths.get(i);
            if (xmlPath.getFileName().toString().equals(currentSchema)) {
                hasCurrentSchema = true;
            }
            String propsPath = xmlPath.toString().replaceAll("\\.xml$", ".properties");
            Properties properties = new Properties();
            try (FileReader r = new FileReader(propsPath);){
                properties.load(r);
            }
            data.add(new Object[]{xmlPath, properties, xmlPath.getFileName().toString()});
        }
        Assert.assertTrue((String)("Could not find a '" + currentSchema + ".xml' configuration file"), (boolean)hasCurrentSchema);
        return data;
    }

    protected String getSubsystemXsdPath() {
        return this.xsdPath;
    }

    protected Properties getResolvedProperties() {
        Properties properties = new Properties();
        properties.setProperty("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
        return properties;
    }

    public void testSchemaOfSubsystemTemplates() {
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new JGroupsSubsystemInitialization();
    }

    protected void compare(ModelNode model1, ModelNode model2) {
        SubsystemParsingTestCase.purgeJGroupsModel(model1);
        SubsystemParsingTestCase.purgeJGroupsModel(model2);
        super.compare(model1, model2);
    }

    private static void purgeJGroupsModel(ModelNode model) {
        model.get(JGroupsSubsystemResourceDefinition.PATH.getKey()).remove(JGroupsSubsystemResourceDefinition.PATH.getValue());
    }

    protected ModelDescriptionValidator.ValidationConfiguration getModelValidationConfiguration() {
        return new ModelDescriptionValidator.ValidationConfiguration();
    }

    @Test
    public void testParseSubsystem() throws Exception {
        List operations = this.parse((AdditionalParsers)this.createAdditionalInitialization(), this.getSubsystemXml());
        Assert.assertEquals((String)operations.toString(), (long)this.expectedOperationCount, (long)operations.size());
    }

    @Test
    public void testInstallIntoController() throws Exception {
        KernelServices services = this.createKernelServicesBuilder().setSubsystemXml(this.getSubsystemXml()).build();
        ModelNode model = services.readWholeModel();
        Assert.assertTrue((boolean)model.get(InfinispanSubsystemRootResource.PATH.getKey()).hasDefined(InfinispanSubsystemRootResource.PATH.getValue()));
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(this.createAdditionalInitialization());
    }

    @Test
    public void testParseAndMarshalModel() throws Exception {
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(this.getSubsystemXml()).build();
        ModelNode modelA = servicesA.readWholeModel();
        String marshalled = servicesA.getPersistedSubsystemXml();
        KernelServices servicesB = this.createKernelServicesBuilder().setSubsystemXml(marshalled).build();
        ModelNode modelB = servicesB.readWholeModel();
        this.compare(modelA, modelB);
    }

    @Test
    public void testDescribeHandler() throws Exception {
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(this.getSubsystemXml()).build();
        ModelNode modelA = servicesA.readWholeModel();
        ModelNode operation = Operations.createDescribeOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanSubsystemRootResource.PATH}));
        List operations = SubsystemParsingTestCase.checkResultAndGetContents((ModelNode)servicesA.executeOperation(operation, new InputStream[0])).asList();
        KernelServices servicesB = this.createKernelServicesBuilder().setBootOperations(operations).build();
        ModelNode modelB = servicesB.readWholeModel();
        this.compare(modelA, modelB);
    }
}

