/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.audit.NullAuditLogger;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.commons.service.InjectedValueDependency;
import org.infinispan.server.commons.service.ServiceNameProvider;
import org.infinispan.server.commons.service.ValueDependency;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.server.jgroups.spi.ProtocolStackConfiguration;
import org.infinispan.server.jgroups.spi.TransportConfiguration;
import org.jboss.as.clustering.infinispan.ChannelTransport;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.io.SimpleExternalizer;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CounterManagerConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.GlobalStateLocationConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.ServerLocalConfigurationStorage;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfigurationBuilder;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class CacheContainerConfigurationBuilder
implements Builder<GlobalConfiguration>,
Value<GlobalConfiguration> {
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final InjectedValue<MBeanServer> server = new InjectedValue();
    private final String name;
    private boolean statisticsEnabled;
    private ModuleIdentifier module;
    private List<ModuleIdentifier> modules;
    private AuthorizationConfigurationBuilder authorization = null;
    private ValueDependency<EmbeddedCacheManagerConfigurationService.TransportConfiguration> transport = null;
    private GlobalStateLocationConfigurationBuilder globalStateLocation = null;
    private final InjectedValue<ThreadPoolConfiguration> nonBlockingThreadPool = new InjectedValue();
    private final InjectedValue<ThreadPoolConfiguration> expirationThreadPool = new InjectedValue();
    private final InjectedValue<ThreadPoolConfiguration> listenerThreadPool = new InjectedValue();
    private final InjectedValue<ThreadPoolConfiguration> blockingThreadPool = new InjectedValue();
    private final InjectedValue<ThreadPoolConfiguration> remoteCommandThreadPool = new InjectedValue();
    private final InjectedValue<ThreadPoolConfiguration> transportThreadPool = new InjectedValue();
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final InjectedValue<ModelController> modelController = new InjectedValue();
    private CounterManagerConfigurationBuilder counterManagerConfiguration;

    public CacheContainerConfigurationBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.CONFIGURATION.getServiceName(this.name);
    }

    public ServiceBuilder<GlobalConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.modelController).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, this.server).addDependency(ThreadPoolResource.NON_BLOCKING.getServiceName(this.name), ThreadPoolConfiguration.class, this.nonBlockingThreadPool).addDependency(ThreadPoolResource.BLOCKING.getServiceName(this.name), ThreadPoolConfiguration.class, this.blockingThreadPool).addDependency(ThreadPoolResource.LISTENER.getServiceName(this.name), ThreadPoolConfiguration.class, this.listenerThreadPool).addDependency(ThreadPoolResource.REMOTE_COMMAND.getServiceName(this.name), ThreadPoolConfiguration.class, this.remoteCommandThreadPool).addDependency(ScheduledThreadPoolResource.EXPIRATION.getServiceName(this.name), ThreadPoolConfiguration.class, this.expirationThreadPool);
        if (this.module != null && !this.module.getName().equals("org.infinispan.extension")) {
            builder.addDependency(ServiceModuleLoader.moduleServiceName((ModuleIdentifier)this.module));
        }
        if (this.modules != null) {
            for (ModuleIdentifier moduleIdentifier : this.modules) {
                builder.addDependency(ServiceModuleLoader.moduleServiceName((ModuleIdentifier)moduleIdentifier));
            }
        }
        if (this.transport != null) {
            this.transport.register(builder);
        }
        if (this.globalStateLocation != null) {
            builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, this.pathManager);
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public GlobalConfiguration getValue() {
        EmbeddedCacheManagerConfigurationService.CounterManagerConfiguration counterManager;
        EmbeddedCacheManagerConfigurationService.GlobalStateLocationConfiguration statePersistence;
        EmbeddedCacheManagerConfigurationService.TransportConfiguration transport;
        ClassLoader loader;
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        ModuleLoader moduleLoader = (ModuleLoader)this.loader.getValue();
        builder.serialization().marshaller((Marshaller)new JBossUserMarshaller((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader)));
        try {
            loader = this.makeGlobalClassLoader(moduleLoader, this.module, this.modules);
            builder.classLoader(loader);
            int id = 255;
            for (SimpleExternalizer externalizer : ServiceLoader.load(SimpleExternalizer.class, loader)) {
                InfinispanLogger.ROOT_LOGGER.debugf("Cache container %s will use an externalizer for %s", this.name, externalizer.getTargetClass().getName());
                builder.serialization().addAdvancedExternalizer(id++, (AdvancedExternalizer)externalizer);
            }
        }
        catch (ModuleLoadException e) {
            throw new IllegalStateException(e);
        }
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        EmbeddedCacheManagerConfigurationService.AuthorizationConfiguration authorization = this.authorization != null ? this.authorization.getValue() : null;
        GlobalAuthorizationConfigurationBuilder authorizationBuilder = builder.security().authorization();
        if (authorization != null) {
            authorizationBuilder.enable();
            if (authorization.getAuditLogger() != null) {
                try {
                    authorizationBuilder.auditLogger(Class.forName(authorization.getAuditLogger(), true, loader).asSubclass(AuditLogger.class).newInstance());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else {
                authorizationBuilder.auditLogger((AuditLogger)new NullAuditLogger());
            }
            if (authorization.getPrincipalMapper() != null) {
                try {
                    authorizationBuilder.principalRoleMapper(Class.forName(authorization.getPrincipalMapper(), true, loader).asSubclass(PrincipalRoleMapper.class).newInstance());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else {
                authorizationBuilder.principalRoleMapper((PrincipalRoleMapper)new ClusterRoleMapper());
            }
            for (Map.Entry<String, List<String>> role : authorization.getRoles().entrySet()) {
                GlobalRoleConfigurationBuilder roleBuilder = authorizationBuilder.role(role.getKey());
                for (String perm : role.getValue()) {
                    roleBuilder.permission(perm);
                }
            }
        }
        EmbeddedCacheManagerConfigurationService.TransportConfiguration transportConfiguration = transport = this.transport != null ? (EmbeddedCacheManagerConfigurationService.TransportConfiguration)this.transport.getValue() : null;
        if (transport != null) {
            org.infinispan.configuration.global.TransportConfigurationBuilder transportBuilder = builder.transport().clusterName(this.name).transport((Transport)new ChannelTransport(transport.getChannel(), transport.getChannelFactory())).distributedSyncTimeout(transport.getLockTimeout().longValue());
            ProtocolStackConfiguration stack = transport.getChannelFactory().getProtocolStackConfiguration();
            TransportConfiguration.Topology topology = stack.getTransport().getTopology();
            if (topology != null) {
                transportBuilder.siteId(topology.getSite()).rackId(topology.getRack()).machineId(topology.getMachine());
            }
            transportBuilder.transportThreadPool().read((ThreadPoolConfiguration)this.transportThreadPool.getValue());
            transportBuilder.remoteCommandThreadPool().read((ThreadPoolConfiguration)this.remoteCommandThreadPool.getValue());
        }
        EmbeddedCacheManagerConfigurationService.GlobalStateLocationConfiguration globalStateLocationConfiguration = statePersistence = this.globalStateLocation != null ? this.globalStateLocation.getValue() : null;
        if (statePersistence != null) {
            GlobalStateConfigurationBuilder statePersistenceBuilder = builder.globalState().enable();
            String persistentLocation = ((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(statePersistence.getPersistencePath(), statePersistence.getPersistenceRelativeTo());
            statePersistenceBuilder.persistentLocation(persistentLocation);
            String sharedPersistentLocation = ((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(statePersistence.getSharedPersistencePath(), statePersistence.getSharedPersistenceRelativeTo());
            statePersistenceBuilder.sharedPersistentLocation(sharedPersistentLocation);
            String temporaryLocation = ((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(statePersistence.getTemporaryPath(), statePersistence.getTemporaryRelativeTo());
            statePersistenceBuilder.temporaryLocation(temporaryLocation);
            statePersistenceBuilder.configurationStorage(statePersistence.getConfigurationStorage());
            String configurationStorageClass = statePersistence.getConfigurationStorageClass();
            if (configurationStorageClass != null) {
                try {
                    LocalConfigurationStorage localConfigurationStorage = Class.forName(configurationStorageClass, true, loader).asSubclass(LocalConfigurationStorage.class).newInstance();
                    if (localConfigurationStorage instanceof ServerLocalConfigurationStorage) {
                        ServerLocalConfigurationStorage serverLocalConfigurationManager = (ServerLocalConfigurationStorage)localConfigurationStorage;
                        serverLocalConfigurationManager.setRootPath(PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH}).append("cache-container", this.name));
                        serverLocalConfigurationManager.setModelControllerClient(((ModelController)this.modelController.getValue()).createClient((Executor)Executors.newCachedThreadPool()));
                    }
                    statePersistenceBuilder.configurationStorageSupplier(() -> localConfigurationStorage);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        EmbeddedCacheManagerConfigurationService.CounterManagerConfiguration counterManagerConfiguration = counterManager = this.counterManagerConfiguration != null ? this.counterManagerConfiguration.getValue() : null;
        if (counterManager != null) {
            ((org.infinispan.counter.configuration.CounterManagerConfigurationBuilder)builder.addModule(org.infinispan.counter.configuration.CounterManagerConfigurationBuilder.class)).numOwner(counterManager.getNumOwners()).reliability(counterManager.getReliability());
        }
        builder.nonBlockingThreadPool().read((ThreadPoolConfiguration)this.nonBlockingThreadPool.getValue());
        builder.expirationThreadPool().read((ThreadPoolConfiguration)this.expirationThreadPool.getValue());
        builder.listenerThreadPool().read((ThreadPoolConfiguration)this.listenerThreadPool.getValue());
        builder.blockingThreadPool().read((ThreadPoolConfiguration)this.blockingThreadPool.getValue());
        builder.cacheManagerName(this.name).cacheContainer().statistics(this.statisticsEnabled).jmx().enabled(this.statisticsEnabled).mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider((MBeanServer)this.server.getValue())).domain(CacheContainerServiceName.CACHE_CONTAINER.getServiceName("default").getParent().getCanonicalName());
        ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        return builder.build();
    }

    private ClassLoader makeGlobalClassLoader(ModuleLoader moduleLoader, ModuleIdentifier cacheContainerModule, List<ModuleIdentifier> additionalModules) throws ModuleLoadException {
        LinkedHashSet<Object> classLoaders = new LinkedHashSet<Object>();
        if (cacheContainerModule != null) {
            classLoaders.add(moduleLoader.loadModule(cacheContainerModule).getClassLoader());
        }
        if (additionalModules != null) {
            for (ModuleIdentifier additionalModule : additionalModules) {
                classLoaders.add(moduleLoader.loadModule(additionalModule).getClassLoader());
            }
        }
        ClassLoader infinispanSubsystemClassloader = CacheContainerConfiguration.class.getClassLoader();
        if (classLoaders.isEmpty()) {
            return infinispanSubsystemClassloader;
        }
        if (cacheContainerModule == null) {
            classLoaders.add(infinispanSubsystemClassloader);
        }
        if (classLoaders.size() == 1) {
            return (ClassLoader)classLoaders.iterator().next();
        }
        return new AggregatedClassLoader(classLoaders);
    }

    public CacheContainerConfigurationBuilder setModule(ModuleIdentifier module) {
        this.module = module;
        return this;
    }

    public CacheContainerConfigurationBuilder setModules(List<ModuleIdentifier> modules) {
        this.modules = modules;
        return this;
    }

    public CacheContainerConfigurationBuilder setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public TransportConfigurationBuilder setTransport() {
        TransportConfigurationBuilder builder = new TransportConfigurationBuilder(this.name);
        this.transport = new InjectedValueDependency((ServiceNameProvider)builder, EmbeddedCacheManagerConfigurationService.TransportConfiguration.class);
        return builder;
    }

    public AuthorizationConfigurationBuilder setAuthorization() {
        this.authorization = new AuthorizationConfigurationBuilder();
        return this.authorization;
    }

    public GlobalStateLocationConfigurationBuilder setGlobalState() {
        this.globalStateLocation = new GlobalStateLocationConfigurationBuilder();
        return this.globalStateLocation;
    }

    public CounterManagerConfigurationBuilder setCounterManagerConfiguration() {
        this.counterManagerConfiguration = new CounterManagerConfigurationBuilder();
        return this.counterManagerConfiguration;
    }
}

