/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.server.infinispan.spi.service.CounterServiceName;
import org.jboss.as.clustering.infinispan.subsystem.CounterResource;
import org.jboss.as.clustering.infinispan.subsystem.CounterService;
import org.jboss.as.clustering.infinispan.subsystem.RestartableServiceHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class CounterAddHandler
extends AbstractAddStepHandler
implements RestartableServiceHandler {
    CounterAddHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performRuntime(context, operation, model);
        this.installRuntimeServices(context, operation, model, null);
    }

    @Override
    public Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel) throws OperationFailedException {
        String counterName = this.getCounterName(operation);
        String containerName = this.getContainerName(operation);
        String counterType = this.getCounterType(operation);
        CounterConfiguration.Builder b = this.getBuilder(containerModel, counterType);
        this.processModelNode(context, containerModel, b);
        String name = CounterResource.COUNTER_NAME.resolveModelAttribute(context, containerModel).asString();
        if (!counterName.equals(name)) {
            throw new OperationFailedException("Counter node name and node's name attribute should be the same");
        }
        ArrayList controllers = new ArrayList(1);
        ServiceController<?> service = this.installCounterService(context.getServiceTarget(), containerName, counterName, b.build());
        controllers.add(service);
        return controllers;
    }

    @Override
    public void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel) {
        String counterName = this.getCounterName(operation);
        String containerName = this.getContainerName(operation);
        context.removeService(CounterServiceName.getServiceName(containerName, counterName));
    }

    private ServiceController<?> installCounterService(ServiceTarget target, String containerName, String configurationName, CounterConfiguration configuration) {
        InjectedValue container = new InjectedValue();
        CounterConfigurationDependencies dependencies = new CounterConfigurationDependencies((InjectedValue<EmbeddedCacheManager>)container);
        CounterService service = new CounterService(configuration, configurationName, dependencies);
        ServiceBuilder builder = target.addService(CounterServiceName.getServiceName(containerName, configurationName), (Service)service).addDependency(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container);
        return builder.install();
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.populate(operation, model);
    }

    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        for (AttributeDefinition attr : CounterResource.ATTRIBUTES) {
            attr.validateAndSet(fromModel, toModel);
        }
    }

    private String getCounterName(ModelNode operation) {
        PathAddress counterAddress = this.getCounterAddressFromOperation(operation);
        return counterAddress.getLastElement().getValue();
    }

    private String getContainerName(ModelNode operation) {
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        return containerAddress.getLastElement().getValue();
    }

    private PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        PathAddress counterAddress = this.getCounterAddressFromOperation(operation);
        return counterAddress.subAddress(0, counterAddress.size() - 2);
    }

    private String getCounterType(ModelNode operation) {
        PathAddress counterAddress = this.getCounterAddressFromOperation(operation);
        int size = counterAddress.size();
        PathAddress subAddress = counterAddress.subAddress(size - 1, size);
        return subAddress.getLastElement().getKey();
    }

    private PathAddress getCounterAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    private CounterConfiguration.Builder getBuilder(ModelNode counter, String counterType) {
        boolean isWeakCounter = "weak-counter".equals(counterType);
        if (isWeakCounter) {
            return CounterConfiguration.builder((CounterType)CounterType.WEAK);
        }
        ModelNode lowerBoundModel = counter.get("lower-bound");
        ModelNode upperBoundModel = counter.get("upper-bound");
        boolean isBounded = lowerBoundModel.isDefined() || upperBoundModel.isDefined();
        return isBounded ? CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG) : CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG);
    }

    void processModelNode(OperationContext context, ModelNode counter, CounterConfiguration.Builder builder) throws OperationFailedException {
        long initialValue = CounterResource.INITIAL_VALUE.resolveModelAttribute(context, counter).asLong();
        String storageType = CounterResource.STORAGE.resolveModelAttribute(context, counter).asString();
        builder.initialValue(initialValue);
        builder.storage(Storage.valueOf((String)storageType));
    }

    private static class CounterConfigurationDependencies
    implements CounterService.Dependencies {
        private InjectedValue<EmbeddedCacheManager> container;

        public CounterConfigurationDependencies(InjectedValue<EmbeddedCacheManager> container) {
            this.container = container;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }
    }
}

