/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.jibx.maven.AbstractJibxMojo;
import org.jibx.maven.IncludeBaseBinding;
import org.jibx.schema.codegen.CodeGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCodeGenMojo
extends AbstractJibxMojo {
    private static final String DEFAULT_INCLUDES = "*.xsd";
    private boolean verbose;
    private String defaultPackage = null;
    private ArrayList<String> customizations;
    private String defaultNamespace = null;
    ArrayList<String> excludeSchemas;
    ArrayList<String> includeSchemas;
    @Deprecated
    ArrayList<String> includeBindings;
    private Map<String, String> options;
    private MavenProjectHelper projectHelper;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] classpaths;
        String mode;
        this.checkConfiguration();
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Not running JiBX code generator for pom packaging");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            String option = "--" + entry.getKey() + "=" + entry.getValue();
            if (entry.getKey().toString().length() == 1 && Character.isLowerCase(entry.getKey().toString().charAt(0))) {
                this.getLog().debug((CharSequence)("Adding option : -" + entry.getKey() + " " + entry.getValue()));
                args.add("-" + entry.getKey());
                args.add(entry.getValue());
                continue;
            }
            this.getLog().debug((CharSequence)("Adding option: " + option));
            args.add(option);
        }
        if (this.verbose) {
            args.add("-v");
        }
        if (this.defaultPackage != null) {
            args.add("-n");
            args.add(this.defaultPackage);
        }
        args.add("-t");
        args.add(this.getFullPath(this.getTargetDirectory()));
        if (this.customizations.size() > 0) {
            args.add("-c");
            for (String customization : this.customizations) {
                args.add(customization);
            }
        }
        if (this.defaultNamespace != null) {
            args.add("-u");
            args.add(this.defaultNamespace);
        }
        String allBindings = "";
        String[] bindings = new String[]{};
        if (this.isMultiModuleMode()) {
            mode = this.isRestrictedMultiModuleMode() ? "restricted multi-module" : "multi-module";
            classpaths = this.getMultiModuleClasspaths();
        } else {
            mode = "single-module";
            classpaths = this.getSingleModuleClasspaths();
        }
        for (String binding : bindings = this.getBaseBindings(bindings)) {
            if (allBindings.length() > 0) {
                allBindings = allBindings + ",";
            }
            allBindings = allBindings + binding;
        }
        if (allBindings.length() > 0) {
            args.add("-i");
            args.add(allBindings);
        }
        List<String> schemas = this.getSchemas(this.getFullPath(this.getSchemaDirectory()));
        for (String schema : schemas) {
            File file = new File(schema);
            if (file.exists()) {
                args.add(new File(schema).toURI().toString());
                continue;
            }
            try {
                args.add(new URL(schema).toURI().toString());
            }
            catch (URISyntaxException e) {
                this.getLog().warn((CharSequence)"Target schema is not a valid file or URL - Passing location as is");
                args.add(schema);
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)"Target schema is not a valid file or URL - Passing location as is");
                args.add(schema);
            }
        }
        this.getLog().debug((CharSequence)("Adding " + this.getTargetDirectory() + " as source directory..."));
        this.project.addCompileSourceRoot(this.getFullPath(this.getTargetDirectory()));
        try {
            this.getLog().info((CharSequence)("Generating Java sources in " + this.getTargetDirectory() + " from schemas available in " + this.getSchemaDirectory() + "..."));
            CodeGen.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
        }
    }

    public String getSingleModuleBindingPath(String basedir, String includeBinding) {
        boolean relativePath = true;
        if (!(includeBinding.startsWith(File.pathSeparator) || includeBinding.startsWith("/") || includeBinding.contains(","))) {
            try {
                File file = new File(basedir + File.separator + includeBinding);
                if (file.exists()) {
                    relativePath = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!relativePath) {
            includeBinding = basedir + File.separator + includeBinding;
        }
        return includeBinding;
    }

    @Override
    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.includeSchemas == null || this.includeSchemas.size() == 0) {
            this.includeSchemas = new ArrayList();
        }
        if (this.excludeSchemas == null) {
            this.excludeSchemas = new ArrayList();
        }
        if (this.includes != null && this.includes.size() > 0) {
            this.includeSchemas.addAll(this.includes);
        }
        if (this.excludes != null && this.excludes.size() > 0) {
            this.excludeSchemas.addAll(this.excludes);
        }
        if (this.includeSchemas.size() == 0) {
            this.includeSchemas.add(DEFAULT_INCLUDES);
        }
        if (this.customizations == null) {
            this.customizations = new ArrayList();
        }
        if (this.includeBindings != null && this.includeBindings.size() > 0) {
            IncludeBaseBinding includeBaseBinding = new IncludeBaseBinding();
            includeBaseBinding.setIncludes(this.includeBindings);
            this.includeBaseBindings.add(includeBaseBinding);
        }
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
    }

    private List<String> getSchemas(String path) throws MojoExecutionException, MojoFailureException {
        return this.getIncludedFiles(path, this.includeSchemas, this.excludeSchemas);
    }

    @Override
    @Deprecated
    protected String getDirectory() {
        return this.getSchemaDirectory();
    }

    protected abstract String getSchemaDirectory();

    protected abstract String getTargetDirectory();

    @Override
    protected String getBindingDirectory() {
        return this.getTargetDirectory();
    }
}

