/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jibx.maven.IncludeBaseBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJibxMojo
extends AbstractMojo {
    static final String DEFAULT_INCLUDE_BINDINGS = "binding.xml";
    protected MavenProject project;
    HashSet<String> modules;
    HashSet<IncludeBaseBinding> includeBaseBindings;
    boolean multimodule;
    @Deprecated
    ArrayList<String> excludes;
    @Deprecated
    ArrayList<String> includes;
    ArrayList<String> excludeSchemaBindings;
    ArrayList<String> includeSchemaBindings;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected String getProjectBasedir(MavenProject project) {
        return FilenameUtils.normalize((String)project.getBasedir().getAbsolutePath());
    }

    protected void checkConfiguration() {
        if (this.includeSchemaBindings == null) {
            this.includeSchemaBindings = new ArrayList();
        }
        if (this.excludeSchemaBindings == null) {
            this.excludeSchemaBindings = new ArrayList();
        }
        if (this.modules != null && this.modules.size() > 0) {
            this.multimodule = true;
        } else {
            this.modules = null;
        }
        if (this.includeBaseBindings == null) {
            this.includeBaseBindings = new HashSet();
        }
    }

    protected List<String> getIncludedFiles(String path, ArrayList<String> includeFiles, ArrayList<String> excludeFiles) throws MojoExecutionException, MojoFailureException {
        ArrayList<String> bindingSet = new ArrayList<String>();
        File bindingdir = new File(path);
        if (!bindingdir.exists()) {
            try {
                URL url = new URL(path);
                if ("file".equalsIgnoreCase(url.getProtocol())) {
                    return bindingSet;
                }
            }
            catch (MalformedURLException e) {
                return bindingSet;
            }
            String[] includes = includeFiles.toArray(new String[includeFiles.size()]);
            if (includes != null && includes.length > 0) {
                for (String include : includes) {
                    bindingSet.add(path + include);
                }
            } else {
                bindingSet.add(path);
            }
        }
        if (!bindingdir.isDirectory()) {
            return bindingSet;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(bindingdir);
        String[] includes = includeFiles.toArray(new String[includeFiles.size()]);
        scanner.setIncludes(includes);
        String[] excludes = excludeFiles.toArray(new String[excludeFiles.size()]);
        scanner.setExcludes(excludes);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        String absolutePath = bindingdir.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            String file = absolutePath + File.separator + files[i];
            bindingSet.add(file);
        }
        return bindingSet;
    }

    protected String fixFilePath(String filePath, String defaultPath) {
        if (filePath == null) {
            return null;
        }
        boolean relativePath = true;
        String basedir = defaultPath;
        if (basedir == null) {
            basedir = this.getProjectBasedir(this.project);
        }
        if (!filePath.startsWith(File.pathSeparator) && !filePath.startsWith("/")) {
            try {
                File file = new File(basedir + File.separator + filePath);
                if (file.exists() || filePath.startsWith("target")) {
                    relativePath = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!relativePath) {
            filePath = basedir + File.separator + filePath;
        }
        return filePath;
    }

    String[] normalizeClasspaths(Set<String> classpathSet) {
        String[] classpaths = classpathSet.toArray(new String[classpathSet.size()]);
        for (int i = 0; i < classpaths.length; ++i) {
            classpaths[i] = FilenameUtils.normalize((String)classpaths[i]);
        }
        return classpaths;
    }

    List<String> getBindings(String path) throws MojoExecutionException, MojoFailureException {
        return this.getIncludedFiles(path, this.includeSchemaBindings, this.excludeSchemaBindings);
    }

    String[] getMultiModuleBindings() throws MojoExecutionException, MojoFailureException {
        Set<String> basedirSet = this.getProjectBasedirSet(this.project);
        HashSet<String> bindingSet = new HashSet<String>();
        for (String basedir : basedirSet) {
            if (basedir.equals(this.getProjectBasedir(this.project))) {
                basedir = this.getFullPath(this.getBindingDirectory());
            }
            List<String> bindingList = this.getBindings(basedir);
            bindingSet.addAll(bindingList);
        }
        return bindingSet.toArray(new String[bindingSet.size()]);
    }

    String[] getMultiModuleClasspaths() throws MojoExecutionException, MojoFailureException {
        Set<String> classpathSet = this.getProjectCompileClasspathElementsSet(this.project);
        return this.normalizeClasspaths(classpathSet);
    }

    private Set<String> getProjectBasedirSet(MavenProject project) {
        HashSet<String> basedirSet = new HashSet<String>();
        basedirSet.add(this.getProjectBasedir(project));
        for (MavenProject projectReference : project.getProjectReferences().values()) {
            String projectId = projectReference.getGroupId() + ":" + projectReference.getArtifactId();
            if (this.modules != null && !this.modules.contains(projectId)) continue;
            basedirSet.add(this.getProjectBasedir(projectReference));
        }
        return basedirSet;
    }

    protected abstract Set<String> getProjectCompileClasspathElements(MavenProject var1) throws MojoExecutionException;

    private Set<String> getProjectCompileClasspathElementsSet(MavenProject project) throws MojoExecutionException {
        HashSet<String> classpathElements = new HashSet<String>();
        classpathElements.addAll(this.getProjectCompileClasspathElements(project));
        for (MavenProject projectReference : project.getProjectReferences().values()) {
            classpathElements.addAll(this.getProjectCompileClasspathElements(projectReference));
        }
        return classpathElements;
    }

    String[] getSingleModuleBindings() throws MojoExecutionException, MojoFailureException {
        String bindingdir = this.getFullPath(this.getBindingDirectory());
        List<String> bindingSet = this.getBindings(bindingdir);
        return bindingSet.toArray(new String[bindingSet.size()]);
    }

    String[] getSingleModuleClasspaths() throws MojoExecutionException, MojoFailureException {
        Set<String> classpathSet = this.getProjectCompileClasspathElements(this.project);
        return this.normalizeClasspaths(classpathSet);
    }

    public String[] getBaseBindings(String[] bindings) {
        List<String> bindingSet = new ArrayList<String>();
        for (String binding : bindings) {
            bindingSet.add(binding);
        }
        if (this.includeBaseBindings.size() > 0) {
            for (IncludeBaseBinding includeDependentBinding : this.includeBaseBindings) {
                if (includeDependentBinding == null) continue;
                String groupId = includeDependentBinding.groupId;
                String artifactId = includeDependentBinding.artifactId;
                if (groupId == null || artifactId == null) {
                    String[] includes;
                    String path;
                    File bindingdir;
                    String directory = includeDependentBinding.directory;
                    if (directory == null) {
                        directory = this.getBindingDirectory();
                    }
                    if (!(bindingdir = new File(path = this.fixFilePath(directory, null))).exists()) {
                        try {
                            URL url = new URL(path);
                            if (!"file".equalsIgnoreCase(url.getProtocol())) {
                                includes = includeDependentBinding.includes.toArray(new String[includeDependentBinding.includes.size()]);
                                if (includes != null && includes.length > 0) {
                                    for (String include : includes) {
                                        bindingSet.add(path + include);
                                    }
                                } else {
                                    bindingSet.add(path);
                                }
                            }
                            return bindingSet.toArray(new String[bindingSet.size()]);
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                    DirectoryScanner scanner = new DirectoryScanner();
                    scanner.setBasedir(bindingdir);
                    includes = includeDependentBinding.includes.toArray(new String[includeDependentBinding.includes.size()]);
                    scanner.setIncludes(includes);
                    for (String include : includes) {
                        if (!include.startsWith(File.separator) && !include.startsWith("/")) continue;
                        for (String includez : includes) {
                            bindingSet.add(includez);
                        }
                        return bindingSet.toArray(new String[bindingSet.size()]);
                    }
                    if (!bindingdir.isDirectory()) {
                        return bindingSet.toArray(new String[bindingSet.size()]);
                    }
                    scanner.scan();
                    String[] files = scanner.getIncludedFiles();
                    String absolutePath = bindingdir.getAbsolutePath();
                    for (int i = 0; i < files.length; ++i) {
                        String file = absolutePath + File.separator + files[i];
                        bindingSet.add(file);
                    }
                    break;
                }
                Set artifacts = this.project.getArtifacts();
                for (Artifact artifact : artifacts) {
                    if (!"jar".equals(artifact.getType()) && !"bundle".equals(artifact.getType()) && !"zip".equals(artifact.getType()) || !groupId.equals(artifact.getGroupId()) || !artifactId.equals(artifact.getArtifactId()) || includeDependentBinding.classifier != null && !includeDependentBinding.classifier.equals(artifact.getClassifier())) continue;
                    ZipFile zip = null;
                    try {
                        zip = new ZipFile(artifact.getFile());
                    }
                    catch (ZipException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (includeDependentBinding.includes == null || includeDependentBinding.includes.size() == 0) {
                        bindingSet = this.extractBindingFile(bindingSet, zip, includeDependentBinding.directory, groupId, artifactId, DEFAULT_INCLUDE_BINDINGS);
                        continue;
                    }
                    for (String include : includeDependentBinding.includes) {
                        bindingSet = this.extractBindingFile(bindingSet, zip, includeDependentBinding.directory, groupId, artifactId, include);
                    }
                }
            }
        }
        return bindingSet.toArray(new String[bindingSet.size()]);
    }

    public List<String> extractBindingFile(List<String> pathList, ZipFile zip, String directory, String groupId, String artifactId, String filePathInJar) {
        try {
            String filenameIn = filePathInJar;
            if (directory != null) {
                filenameIn = directory.endsWith(File.separator) || directory.endsWith("/") ? directory + '/' + filenameIn : directory + '/' + filenameIn;
            }
            ZipEntry entry = zip.getEntry(filenameIn);
            filenameIn = filePathInJar;
            int lastSlash = filenameIn.lastIndexOf(File.separator);
            if (lastSlash == -1) {
                lastSlash = filenameIn.lastIndexOf(47);
            }
            String startFilePath = "";
            if (lastSlash != -1) {
                startFilePath = File.separator + filenameIn.substring(0, lastSlash);
                filenameIn = filenameIn.substring(lastSlash + 1);
            }
            if (entry != null) {
                String filenameOut = this.getFullPath(this.getBindingDirectory()) + startFilePath;
                new File(filenameOut).mkdirs();
                filenameOut = filenameOut + File.separator + groupId + '-' + artifactId + '-' + filenameIn;
                File fileOut = new File(filenameOut);
                if (fileOut.exists()) {
                    fileOut.delete();
                }
                InputStream inStream = zip.getInputStream(entry);
                if (fileOut.createNewFile()) {
                    FileOutputStream outStream = new FileOutputStream(filenameOut);
                    byte[] b = new byte[1000];
                    int size = 0;
                    while ((size = inStream.read(b)) > 0) {
                        ((OutputStream)outStream).write(b, 0, size);
                    }
                    ((OutputStream)outStream).close();
                    inStream.close();
                    pathList.add(filenameOut);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pathList;
    }

    boolean isMultiModuleMode() {
        return this.multimodule;
    }

    boolean isRestrictedMultiModuleMode() {
        return this.isMultiModuleMode() && this.modules != null;
    }

    boolean isSingleModuleMode() {
        return !this.isMultiModuleMode();
    }

    @Deprecated
    protected String getDirectory() {
        return this.getBindingDirectory();
    }

    protected abstract String getBindingDirectory();

    public String getFullPath(String dir) {
        try {
            URL url = new URL(dir);
            if (!"file".equalsIgnoreCase(url.getProtocol())) {
                return dir;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (!dir.startsWith(File.separator) && !dir.startsWith("/")) {
            dir = this.getProjectBasedir(this.project) + File.separator + dir;
        }
        return dir;
    }
}

