/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import java.util.Properties;
import org.jboss.as.jpa.hibernate4.infinispan.SharedInfinispanRegionFactory;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.core.internal.Notification;

public class HibernateSecondLevelCache {
    private static final String DEFAULT_REGION_FACTORY = SharedInfinispanRegionFactory.class.getName();
    public static final String CACHE_TYPE = "cachetype";
    public static final String CONTAINER = "container";
    public static final String COLLECTION = "collection";
    public static final String ENTITY = "entity";
    public static final String NAME = "name";
    public static final String QUERY = "query";
    public static final String TIMESTAMPS = "timestamps";

    public static void addSecondLevelCacheDependencies(Properties mutableProperties, String scopedPersistenceUnitName) {
        String regionFactory;
        if (mutableProperties.getProperty("hibernate.cache.region_prefix") == null && scopedPersistenceUnitName != null) {
            mutableProperties.setProperty("hibernate.cache.region_prefix", scopedPersistenceUnitName);
        }
        if ((regionFactory = mutableProperties.getProperty("hibernate.cache.region.factory_class")) == null) {
            regionFactory = DEFAULT_REGION_FACTORY;
            mutableProperties.setProperty("hibernate.cache.region.factory_class", regionFactory);
        }
        if (regionFactory.equals(DEFAULT_REGION_FACTORY)) {
            String container = mutableProperties.getProperty("hibernate.cache.infinispan.container");
            if (container == null) {
                container = "hibernate";
                mutableProperties.setProperty("hibernate.cache.infinispan.container", container);
            }
            Properties cacheSettings = new Properties();
            cacheSettings.put(CONTAINER, container);
            cacheSettings.put(ENTITY, mutableProperties.getProperty("hibernate.cache.infinispan.entity.cfg", ENTITY));
            cacheSettings.put(COLLECTION, mutableProperties.getProperty("hibernate.cache.infinispan.collection.cfg", ENTITY));
            if (Boolean.parseBoolean(mutableProperties.getProperty("hibernate.cache.use_query_cache"))) {
                cacheSettings.put(QUERY, mutableProperties.getProperty("hibernate.cache.infinispan.query.cfg", "local-query"));
                cacheSettings.put(TIMESTAMPS, mutableProperties.getProperty("hibernate.cache.infinispan.timestamps.cfg", "local-query"));
            }
            Notification.addCacheDependencies((Classification)Classification.INFINISPAN, (Properties)cacheSettings);
            String entity = mutableProperties.getProperty("hibernate.cache.infinispan.entity.cfg", ENTITY);
            String collection = mutableProperties.getProperty("hibernate.cache.infinispan.collection.cfg", ENTITY);
            if (Boolean.parseBoolean(mutableProperties.getProperty("hibernate.cache.use_query_cache"))) {
                String query = mutableProperties.getProperty("hibernate.cache.infinispan.query.cfg", "local-query");
                String timestamps = mutableProperties.getProperty("hibernate.cache.infinispan.timestamps.cfg", "local-query");
            }
        }
    }
}

