/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.Statistics;
import org.jboss.as.jpa.hibernate4.management.HibernateAbstractStatistics;
import org.jipijapa.management.spi.EntityManagerFactoryAccess;
import org.jipijapa.management.spi.Operation;
import org.jipijapa.management.spi.PathAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCollectionStatistics
extends HibernateAbstractStatistics {
    private static final String ATTRIBUTE_COLLECTION_NAME = "collection-name";
    public static final String OPERATION_COLLECTION_LOAD_COUNT = "collection-load-count";
    public static final String OPERATION_COLLECTION_FETCH_COUNT = "collection-fetch-count";
    public static final String OPERATION_COLLECTION_UPDATE_COUNT = "collection-update-count";
    public static final String OPERATION_COLLECTION_REMOVE_COUNT = "collection-remove-count";
    public static final String OPERATION_COLLECTION_RECREATED_COUNT = "collection-recreated-count";
    private Operation showCollectionName = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateCollectionStatistics.this.getStatisticName(args);
        }
    };
    private Operation collectionUpdateCount = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args)).getUpdateCount();
        }
    };
    private Operation collectionRemoveCount = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args)).getRemoveCount();
        }
    };
    private Operation collectionRecreatedCount = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args)).getRemoveCount();
        }
    };
    private Operation collectionLoadCount = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args)).getLoadCount();
        }
    };
    private Operation collectionFetchCount = new Operation(){

        public Object invoke(Object ... args) {
            return HibernateCollectionStatistics.this.getStatistics(HibernateCollectionStatistics.this.getEntityManagerFactory(args), HibernateCollectionStatistics.this.getStatisticName(args)).getFetchCount();
        }
    };

    public HibernateCollectionStatistics() {
        this.operations.put(ATTRIBUTE_COLLECTION_NAME, this.showCollectionName);
        this.types.put(ATTRIBUTE_COLLECTION_NAME, String.class);
        this.operations.put(OPERATION_COLLECTION_LOAD_COUNT, this.collectionLoadCount);
        this.types.put(OPERATION_COLLECTION_LOAD_COUNT, Long.class);
        this.operations.put(OPERATION_COLLECTION_FETCH_COUNT, this.collectionFetchCount);
        this.types.put(OPERATION_COLLECTION_FETCH_COUNT, Long.class);
        this.operations.put(OPERATION_COLLECTION_UPDATE_COUNT, this.collectionUpdateCount);
        this.types.put(OPERATION_COLLECTION_UPDATE_COUNT, Long.class);
        this.operations.put(OPERATION_COLLECTION_REMOVE_COUNT, this.collectionRemoveCount);
        this.types.put(OPERATION_COLLECTION_REMOVE_COUNT, Long.class);
        this.operations.put(OPERATION_COLLECTION_RECREATED_COUNT, this.collectionRecreatedCount);
        this.types.put(OPERATION_COLLECTION_RECREATED_COUNT, Long.class);
    }

    public Collection<String> getDynamicChildrenNames(EntityManagerFactoryAccess entityManagerFactoryLookup, PathAddress pathAddress) {
        return Collections.unmodifiableCollection(Arrays.asList(this.getBaseStatistics(entityManagerFactoryLookup.entityManagerFactory(pathAddress.getValue("hibernate-persistence-unit"))).getCollectionRoleNames()));
    }

    private Statistics getBaseStatistics(EntityManagerFactory entityManagerFactory) {
        HibernateEntityManagerFactory entityManagerFactoryImpl = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactory sessionFactory = entityManagerFactoryImpl.getSessionFactory();
        if (sessionFactory != null) {
            return sessionFactory.getStatistics();
        }
        return null;
    }

    private CollectionStatistics getStatistics(EntityManagerFactory entityManagerFactory, String collectionName) {
        HibernateEntityManagerFactory entityManagerFactoryImpl = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactory sessionFactory = entityManagerFactoryImpl.getSessionFactory();
        if (sessionFactory != null) {
            return sessionFactory.getStatistics().getCollectionStatistics(collectionName);
        }
        return null;
    }
}

