/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.Strings;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class ArrayUtil {
    private static final Function<String, Integer> INT_PARSER = new Function<String, Integer>(){

        public Integer apply(String string) {
            return (Integer)Numbers.INTEGER_INTERNER.intern((Object)Integer.parseInt(string));
        }
    };
    private static final Function<String, Double> REAL_PARSER = new Function<String, Double>(){

        public Double apply(String string) {
            return (Double)Numbers.DOUBLE_INTERNER.intern((Object)Double.parseDouble(string));
        }
    };
    private static final Function<String, String> STRING_PARSER = new Function<String, String>(){

        public String apply(String string) {
            return (String)Strings.INTERNER.intern((Object)string);
        }
    };
    private static final LoadingCache<Array, List<?>> contentCache = CacheUtil.buildLoadingCache(new CacheLoader<Array, List<?>>(){

        public List<?> load(Array array) {
            return ImmutableList.copyOf(ArrayUtil.parse(array));
        }
    });

    private ArrayUtil() {
    }

    public static int getSize(Array array) {
        Integer n = array.getN();
        if (n != null) {
            return n;
        }
        List<?> content = ArrayUtil.getContent(array);
        return content.size();
    }

    public static List<?> getContent(Array array) {
        return CacheUtil.getValue(array, contentCache);
    }

    public static List<? extends Number> asNumberList(Array array) {
        List<?> content = ArrayUtil.getContent(array);
        Array.Type type = array.getType();
        if (type == null) {
            throw new MissingAttributeException((PMMLObject)array, PMMLAttributes.ARRAY_TYPE);
        }
        switch (type) {
            case INT: 
            case REAL: {
                return content;
            }
            case STRING: {
                throw new InvalidElementException((PMMLObject)array);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)array, (Enum<?>)type);
    }

    public static List<?> parse(Array array) {
        List tokens;
        Array.Type type = array.getType();
        if (type == null) {
            throw new MissingAttributeException((PMMLObject)array, PMMLAttributes.ARRAY_TYPE);
        }
        String value = array.getValue();
        switch (type) {
            case INT: 
            case REAL: {
                tokens = org.jpmml.model.ArrayUtil.parse((String)value, (boolean)false);
                break;
            }
            case STRING: {
                tokens = org.jpmml.model.ArrayUtil.parse((String)value, (boolean)true);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)array, (Enum<?>)type);
            }
        }
        Integer n = array.getN();
        if (n != null && n.intValue() != tokens.size()) {
            throw new InvalidElementException((PMMLObject)array);
        }
        switch (type) {
            case INT: {
                return Lists.transform((List)tokens, INT_PARSER);
            }
            case REAL: {
                return Lists.transform((List)tokens, REAL_PARSER);
            }
            case STRING: {
                return Lists.transform((List)tokens, STRING_PARSER);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)array, (Enum<?>)type);
    }
}

