/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.functions.AbstractNumericFunction;

public abstract class ArithmeticFunction
extends AbstractNumericFunction {
    public ArithmeticFunction(String name) {
        super(name);
    }

    public abstract Number evaluate(Number var1, Number var2);

    @Override
    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkFixedArityArguments(arguments, 2);
        return this.evaluate(this.getOptionalArgument(arguments, 0), this.getOptionalArgument(arguments, 1));
    }

    private FieldValue evaluate(FieldValue left, FieldValue right) {
        Number result;
        if (Objects.equals(FieldValues.MISSING_VALUE, left) || Objects.equals(FieldValues.MISSING_VALUE, right)) {
            return FieldValues.MISSING_VALUE;
        }
        DataType dataType = TypeUtil.getCommonDataType(left.getDataType(), right.getDataType());
        try {
            result = this.evaluate(left.asNumber(), right.asNumber());
        }
        catch (ArithmeticException ae) {
            throw new UndefinedResultException().initCause(ae);
        }
        return FieldValueUtil.create(dataType, OpType.CONTINUOUS, result);
    }
}

