/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.net.URI;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.SpacesAPI;
import org.uberfire.util.URIUtil;

public class SpaceConfigStorageImpl
implements SpaceConfigStorage {
    public static final String FILE_FORMAT = ".json";
    public static final String BRANCH_PERMISSIONS = "BranchPermissions";
    public static final String SPACE_INFO = "SpaceInfo";
    private ObjectStorage objectStorage;
    private IOService ioService;
    private String spaceName;

    public SpaceConfigStorageImpl() {
    }

    @Inject
    public SpaceConfigStorageImpl(ObjectStorage objectStorage, @Named(value="configIO") IOService ioService) {
        this.objectStorage = objectStorage;
        this.ioService = ioService;
    }

    public void setup(String spaceName) {
        this.spaceName = spaceName;
        this.objectStorage.init(this.getRootURI(spaceName));
    }

    public BranchPermissions loadBranchPermissions(String branchName, String projectIdentifier) {
        BranchPermissions branchPermissions = (BranchPermissions)this.objectStorage.read(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS));
        if (branchPermissions == null) {
            return this.getDefaultBranchPermissions(branchName);
        }
        return branchPermissions;
    }

    private URI getRootURI(String spaceName) {
        return URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)spaceName));
    }

    public void saveBranchPermissions(String branchName, String projectIdentifier, BranchPermissions branchPermissions) {
        this.objectStorage.write(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS), (Object)branchPermissions);
    }

    public void deleteBranchPermissions(String branchName, String projectIdentifier) {
        this.objectStorage.delete(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS));
    }

    BranchPermissions getDefaultBranchPermissions(String branchName) {
        LinkedHashMap<String, RolePermissions> defaultPermissions = new LinkedHashMap<String, RolePermissions>();
        defaultPermissions.put(ContributorType.OWNER.name(), new RolePermissions(ContributorType.OWNER.name(), true, true, true, true));
        defaultPermissions.put(ContributorType.ADMIN.name(), new RolePermissions(ContributorType.ADMIN.name(), true, true, false, true));
        defaultPermissions.put(ContributorType.CONTRIBUTOR.name(), new RolePermissions(ContributorType.CONTRIBUTOR.name(), true, true, false, false));
        return new BranchPermissions(branchName, defaultPermissions);
    }

    public SpaceInfo loadSpaceInfo() {
        return (SpaceInfo)this.objectStorage.read(this.buildSpaceConfigFilePath(SPACE_INFO));
    }

    public void saveSpaceInfo(SpaceInfo spaceInfo) {
        this.objectStorage.write(this.buildSpaceConfigFilePath(SPACE_INFO), (Object)spaceInfo, false);
    }

    public void startBatch() {
        this.ioService.startBatch(this.ioService.get(this.getRootURI(this.spaceName)).getFileSystem());
    }

    public void endBatch() {
        this.ioService.endBatch();
    }

    public void close() {
        this.objectStorage.close();
    }

    public boolean isInitialized() {
        return this.loadSpaceInfo() != null;
    }

    String buildSpaceConfigFilePath(String configName) {
        return "/config/" + configName + FILE_FORMAT;
    }

    String buildProjectConfigFilePath(String projectIdentifier, String configName) {
        return "/config/" + this.encode(projectIdentifier) + "/" + configName + FILE_FORMAT;
    }

    String buildBranchConfigFilePath(String branchName, String projectIdentifier, String configName) {
        return "/config/" + this.encode(projectIdentifier) + "/" + this.encode(branchName) + "/" + configName + FILE_FORMAT;
    }

    private String encode(String text) {
        return URIUtil.encodeQueryString((String)text);
    }

    public Path getPath() {
        URI configPathURI = this.getConfigPathUri();
        return this.ioService.get(configPathURI);
    }

    private URI getConfigPathUri() {
        return URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)this.spaceName));
    }
}

