/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.pmml;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.kie.api.io.Resource;
import org.kie.api.pmml.PMML4Field;
import org.kie.api.pmml.PMML4Result;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNFunctionDefinitionEvaluator;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.pmml.AbstractPMMLInvocationEvaluator;
import org.kie.dmn.core.pmml.PMMLInfo;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.pmml.pmml_4_2.PMML4ExecutionHelper;
import org.kie.pmml.pmml_4_2.PMMLRequestDataBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNKiePMMLInvocationEvaluator
extends AbstractPMMLInvocationEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(DMNKiePMMLInvocationEvaluator.class);
    private final PMML4ExecutionHelper helper;
    private final PMMLInfo<?> pmmlInfo;

    public DMNKiePMMLInvocationEvaluator(String dmnNS, DMNElement node, Resource pmmlResource, String model, PMMLInfo<?> pmmlInfo) {
        super(dmnNS, node, pmmlResource, model);
        this.pmmlInfo = pmmlInfo;
        this.helper = PMML4ExecutionHelper.PMML4ExecutionHelperFactory.getExecutionHelper((String)model, (Resource)pmmlResource, null, (boolean)pmmlInfo.getModels().stream().anyMatch(m -> "MiningModel".equals(m.className) && (model != null && model.equals(m.name) || model == null && m.name == null)));
        this.helper.addPossiblePackageName(pmmlInfo.getHeader().getHeaderExtensions().get("modelPackage"));
        this.helper.initModel();
    }

    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        PMMLRequestDataBuilder request = new PMMLRequestDataBuilder(UUID.randomUUID().toString(), this.model);
        for (DMNFunctionDefinitionEvaluator.FormalParameter p : this.parameters) {
            Object pValue = DMNKiePMMLInvocationEvaluator.getValueForPMMLInput(dmnr, p.name);
            Class<?> class1 = pValue.getClass();
            request.addParameter(p.name, pValue, class1);
        }
        PMML4Result resultHolder = this.helper.submitRequest(request.build());
        Map resultVariables = resultHolder.getResultVariables();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry kv : resultVariables.entrySet()) {
            Object r = kv.getValue();
            if (!(r instanceof PMML4Field)) continue;
            PMML4Field pmml4Field = (PMML4Field)r;
            String resultName = (String)kv.getKey();
            if (resultName == null || resultName.isEmpty()) continue;
            String name = resultName;
            Optional<String> outputFieldNameFromInfo = this.pmmlInfo.getModels().stream().filter(m -> this.model.equals(m.getName())).flatMap(m -> m.getOutputFieldNames().stream()).filter(ofn -> ofn.equalsIgnoreCase(resultName)).findFirst();
            if (outputFieldNameFromInfo.isPresent()) {
                name = outputFieldNameFromInfo.get();
            }
            try {
                Method method = r.getClass().getMethod("getValue", new Class[0]);
                Object value = method.invoke(r, new Object[0]);
                result.put(name, EvalHelper.coerceNumber((Object)value));
            }
            catch (Throwable e) {
                MsgUtil.reportMessage(LOG, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)this.node, (DMNResultImpl)((Object)result), e, null, Msg.INVALID_NAME, name, e.getMessage());
                result.put(name, null);
            }
        }
        return new EvaluatorResultImpl(result, EvaluatorResult.ResultType.SUCCESS);
    }
}

