/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.services.backend.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class VFSScanner<TYPE> {
    private IOService ioService;
    private Path rootPath;
    private Collection<String> extensions;
    private Function<InputStream, TYPE> converter;
    private Predicate<TYPE> filter;
    private List<ScanResult<TYPE>> results = new ArrayList<ScanResult<TYPE>>();

    private VFSScanner(IOService ioService, Path rootPath, Collection<String> extensions, Function<InputStream, TYPE> converter, Predicate<TYPE> filter) {
        this.ioService = ioService;
        this.rootPath = rootPath;
        this.extensions = extensions;
        this.converter = converter;
        this.filter = filter;
    }

    public static <TYPE> Collection<ScanResult<TYPE>> scan(IOService ioService, Path rootPath, Collection<String> extensions, Function<InputStream, TYPE> converter) {
        return VFSScanner.scan(ioService, rootPath, extensions, converter, resource -> true);
    }

    public static <TYPE> Collection<ScanResult<TYPE>> scan(IOService ioService, Path rootPath, Collection<String> extensions, Function<InputStream, TYPE> converter, Predicate<TYPE> filter) {
        VFSScanner<TYPE> scanner = new VFSScanner<TYPE>(ioService, rootPath, extensions, converter, filter);
        return super.scanPath();
    }

    private Collection<ScanResult<TYPE>> scanPath() {
        this.scanPath(this.rootPath);
        return this.results;
    }

    private void scanPath(Path path) {
        if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
            this.ioService.newDirectoryStream(path).forEach(this::scanPath);
        } else {
            TYPE source;
            String filename = path.getFileName().toString();
            String extension = FilenameUtils.getExtension((String)filename);
            if (this.extensions.contains(extension) && this.filter.test(source = this.converter.apply(this.ioService.newInputStream(path, new OpenOption[0])))) {
                this.results.add(new ScanResult(path, source));
            }
        }
    }

    public static class ScanResult<TYPE> {
        private Path assetPath;
        private TYPE resource;

        private ScanResult(Path assetPath, TYPE resource) {
            this.assetPath = assetPath;
            this.resource = resource;
        }

        public Path getAssetPath() {
            return this.assetPath;
        }

        public TYPE getResource() {
            return this.resource;
        }
    }
}

