/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.iterator;

import java.util.Iterator;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

public abstract class AbstractRandomChangeIterator<S extends Move>
extends UpcomingSelectionIterator<S> {
    private final EntitySelector entitySelector;
    private final ValueSelector valueSelector;
    private Iterator<Object> entityIterator;

    public AbstractRandomChangeIterator(EntitySelector entitySelector, ValueSelector valueSelector) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.entityIterator = entitySelector.iterator();
    }

    @Override
    protected S createUpcomingSelection() {
        if (!this.entityIterator.hasNext()) {
            this.entityIterator = this.entitySelector.iterator();
            if (!this.entityIterator.hasNext()) {
                return (S)((Move)this.noUpcomingSelection());
            }
        }
        Object entity = this.entityIterator.next();
        Iterator<Object> valueIterator = this.valueSelector.iterator(entity);
        int entityIteratorCreationCount = 0;
        while (!valueIterator.hasNext()) {
            if (!this.entityIterator.hasNext()) {
                this.entityIterator = this.entitySelector.iterator();
                if (++entityIteratorCreationCount >= 2) {
                    return (S)((Move)this.noUpcomingSelection());
                }
            }
            entity = this.entityIterator.next();
            valueIterator = this.valueSelector.iterator(entity);
        }
        Object toValue = valueIterator.next();
        return this.newChangeSelection(entity, toValue);
    }

    protected abstract S newChangeSelection(Object var1, Object var2);
}

