/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.List;
import java.util.function.Function;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsConstraint<Solution_>
implements Constraint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DroolsConstraint.class);
    private final DroolsConstraintFactory<Solution_> constraintFactory;
    private final String constraintPackage;
    private final String constraintName;
    private final boolean positive;
    private final List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList;
    private final DroolsAbstractConstraintStream<Solution_> scoringStream;
    private Function<Solution_, Score<?>> constraintWeightExtractor;

    public DroolsConstraint(DroolsConstraintFactory<Solution_> constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, boolean positive, List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList, DroolsAbstractConstraintStream<Solution_> scoringStream) {
        this.constraintFactory = constraintFactory;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.positive = positive;
        this.fromStreamList = fromStreamList;
        this.scoringStream = scoringStream;
    }

    public Score<?> extractConstraintWeight(Solution_ workingSolution) {
        Score<?> constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        this.constraintFactory.getSolutionDescriptor().validateConstraintWeight(this.constraintPackage, this.constraintName, constraintWeight);
        return this.positive ? constraintWeight : constraintWeight.negate();
    }

    public Rule createRule(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        Rule result = PatternDSL.rule((String)this.getConstraintPackage(), (String)this.getConstraintName()).build(this.scoringStream.createRuleItemBuilders(scoreHolderGlobal).toArray(new RuleItemBuilder[0]));
        LOGGER.trace("Constraint stream {} resulted in a new Drools rule: {}.", this.scoringStream, (Object)result);
        return result;
    }

    @Override
    public DroolsConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    public int getConstraintStreamCardinality() {
        if (this.scoringStream instanceof UniConstraintStream) {
            return 1;
        }
        if (this.scoringStream instanceof BiConstraintStream) {
            return 2;
        }
        if (this.scoringStream instanceof TriConstraintStream) {
            return 3;
        }
        if (this.scoringStream instanceof QuadConstraintStream) {
            return 4;
        }
        throw new UnsupportedOperationException("Unknown cardinality for constraint stream (" + this.scoringStream + ").");
    }

    public String toString() {
        return "DroolsConstraint(" + this.getConstraintId() + ") in " + this.fromStreamList.size() + " from() stream(s)";
    }
}

