/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.tri;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.tri.CompositeTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.SingleTriJoiner;

public abstract class AbstractTriJoiner<A, B, C>
extends AbstractJoiner
implements TriJoiner<A, B, C> {
    @SafeVarargs
    public static final <A, B, C> TriJoiner<A, B, C> merge(TriJoiner<A, B, C> ... joiners) {
        ArrayList joinerList = new ArrayList();
        for (TriJoiner<A, B, C> joiner : joiners) {
            if (joiner instanceof NoneTriJoiner) continue;
            if (joiner instanceof SingleTriJoiner) {
                joinerList.add((SingleTriJoiner)joiner);
                continue;
            }
            if (joiner instanceof CompositeTriJoiner) {
                joinerList.addAll(((CompositeTriJoiner)joiner).getJoinerList());
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        if (joinerList.isEmpty()) {
            return new NoneTriJoiner();
        }
        if (joinerList.size() == 1) {
            return (TriJoiner)joinerList.get(0);
        }
        return new CompositeTriJoiner(joinerList);
    }

    public abstract BiFunction<A, B, Object> getLeftMapping(int var1);

    public abstract BiFunction<A, B, Object[]> getLeftCombinedMapping();

    public abstract Function<C, Object> getRightMapping(int var1);

    public abstract Function<C, Object[]> getRightCombinedMapping();
}

