/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.drools.model.Global;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.common.AbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public abstract class DroolsAbstractConstraintStream<Solution_>
extends AbstractConstraintStream<Solution_> {
    protected final DroolsConstraintFactory<Solution_> constraintFactory;
    private final List<DroolsAbstractConstraintStream<Solution_>> childStreamList = new ArrayList<DroolsAbstractConstraintStream<Solution_>>(2);

    public DroolsAbstractConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory) {
        this.constraintFactory = constraintFactory;
    }

    protected DroolsConstraint<Solution_> buildConstraint(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive, DroolsAbstractConstraintStream<Solution_> scoringStream) {
        Function constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName, constraintWeight);
        List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList = this.getFromStreamList();
        return new DroolsConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, positive, fromStreamList, scoringStream);
    }

    protected DroolsConstraint<Solution_> buildConstraintConfigurable(String constraintPackage, String constraintName, boolean positive, DroolsAbstractConstraintStream<Solution_> scoringStream) {
        Function constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName);
        List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList = this.getFromStreamList();
        return new DroolsConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, positive, fromStreamList, scoringStream);
    }

    public abstract List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList();

    public void addChildStream(DroolsAbstractConstraintStream<Solution_> childStream) {
        this.childStreamList.add(childStream);
    }

    public Collection<DroolsAbstractConstraintStream<Solution_>> getChildStreams() {
        return Collections.unmodifiableList(this.childStreamList);
    }

    public List<RuleItemBuilder<?>> createRuleItemBuilders(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        throw new UnsupportedOperationException("Non-scoring stream (" + this + ") can not create a rule.");
    }

    public abstract boolean isGroupByAllowed();

    protected void throwWhenGroupByNotAllowed() {
        if (!this.isGroupByAllowed()) {
            throw new UnsupportedOperationException("Repeated groupBy() calls are not yet supported.");
        }
    }

    @Override
    public DroolsConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }
}

