/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.core.Bpmn2Import;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="WebServiceDefinitions.wid", name="WebService", displayName="WebService", defaultHandler="mvel: new org.jbpm.process.workitem.webservice.WebServiceWorkItemHandler()", documentation="jbpm-workitems-webservice/index.html", category="jbpm-workitems-webservice", icon="WebService.png", parameters={@WidParameter(name="Url"), @WidParameter(name="Namespace"), @WidParameter(name="Interface"), @WidParameter(name="Operation"), @WidParameter(name="Endpoint"), @WidParameter(name="Parameter"), @WidParameter(name="Mode")}, results={@WidResult(name="Result", runtimeType="java.lang.Object")}, mavenDepends={@WidMavenDepends(group="org.jbpm", artifact="jbpm-workitems-webservice", version="7.32.0-SNAPSHOT")}, serviceInfo=@WidService(category="WebService", description="Perform WebService operations", keywords="webservice,call", action=@WidAction(title="Perform a WebService call")))
public class WebServiceWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    public static final String WSDL_IMPORT_TYPE = "http://schemas.xmlsoap.org/wsdl/";
    private static Logger logger = LoggerFactory.getLogger(WebServiceWorkItemHandler.class);
    private final Long defaultJbpmCxfClientConnectionTimeout = Long.parseLong(System.getProperty("org.jbpm.cxf.client.connectionTimeout", "30000"));
    private final Long defaultJbpmCxfClientReceiveTimeout = Long.parseLong(System.getProperty("org.jbpm.cxf.client.receiveTimeout", "60000"));
    private ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    private DynamicClientFactory dcf = null;
    private KieSession ksession;
    private int asyncTimeout = 10;
    private ClassLoader classLoader;
    private String username;
    private String password;

    public WebServiceWorkItemHandler() {
        this.ksession = null;
        this.username = null;
        this.password = null;
    }

    public WebServiceWorkItemHandler(KieSession ksession) {
        this(ksession, null, null);
    }

    public WebServiceWorkItemHandler(KieSession kieSession, String username, String password) {
        this.ksession = kieSession;
        this.username = username;
        this.password = password;
    }

    public WebServiceWorkItemHandler(KieSession ksession, ClassLoader classloader) {
        this(ksession, classloader, null, null);
    }

    public WebServiceWorkItemHandler(KieSession ksession, ClassLoader classloader, String username, String password) {
        this.ksession = ksession;
        this.classLoader = classloader;
        this.username = username;
        this.password = password;
    }

    public WebServiceWorkItemHandler(KieSession ksession, int timeout) {
        this(ksession, timeout, null, null);
    }

    public WebServiceWorkItemHandler(KieSession ksession, int timeout, String username, String password) {
        this.ksession = ksession;
        this.asyncTimeout = timeout;
        this.username = username;
        this.password = password;
    }

    public WebServiceWorkItemHandler(String handlingProcessId, String handlingStrategy, KieSession ksession) {
        this(ksession, null, null);
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    public WebServiceWorkItemHandler(String handlingProcessId, String handlingStrategy, KieSession kieSession, String username, String password) {
        this.ksession = kieSession;
        this.username = username;
        this.password = password;
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    public WebServiceWorkItemHandler(String handlingProcessId, String handlingStrategy, KieSession ksession, ClassLoader classloader) {
        this(ksession, classloader, null, null);
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    public WebServiceWorkItemHandler(String handlingProcessId, String handlingStrategy, KieSession ksession, ClassLoader classloader, String username, String password) {
        this.ksession = ksession;
        this.classLoader = classloader;
        this.username = username;
        this.password = password;
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    public WebServiceWorkItemHandler(String handlingProcessId, String handlingStrategy, KieSession ksession, int timeout) {
        this(ksession, timeout, null, null);
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    public WebServiceWorkItemHandler(String handlingProcessId, String handlingStrategy, KieSession ksession, int timeout, String username, String password) {
        this.ksession = ksession;
        this.asyncTimeout = timeout;
        this.username = username;
        this.password = password;
        this.handlingProcessId = handlingProcessId;
        this.handlingStrategy = handlingStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        ClassLoader origClassloader = Thread.currentThread().getContextClassLoader();
        Object[] parameters = null;
        String interfaceRef = (String)workItem.getParameter("Interface");
        String operationRef = (String)workItem.getParameter("Operation");
        String endpointAddress = (String)workItem.getParameter("Endpoint");
        if (workItem.getParameter("Parameter") instanceof Object[]) {
            parameters = (Object[])workItem.getParameter("Parameter");
        } else if (workItem.getParameter("Parameter") != null && workItem.getParameter("Parameter").getClass().isArray()) {
            int length = Array.getLength(workItem.getParameter("Parameter"));
            parameters = new Object[length];
            for (int i = 0; i < length; ++i) {
                parameters[i] = Array.get(workItem.getParameter("Parameter"), i);
            }
        } else {
            parameters = new Object[]{workItem.getParameter("Parameter")};
        }
        String modeParam = (String)workItem.getParameter("Mode");
        WSMode mode = WSMode.valueOf(modeParam == null ? "SYNC" : modeParam.toUpperCase());
        try {
            Client client = this.getWSClient(workItem, interfaceRef);
            if (client == null) {
                throw new IllegalStateException("Unable to create client for web service " + interfaceRef + " - " + operationRef);
            }
            if (endpointAddress != null && !"".equals(endpointAddress)) {
                client.getRequestContext().put(Message.ENDPOINT_ADDRESS, endpointAddress);
            }
            this.applyAuthorization(this.username, this.password, client);
            switch (mode) {
                case SYNC: {
                    Object[] result = client.invoke(operationRef, parameters);
                    HashMap<String, Object> output = new HashMap<String, Object>();
                    if (result == null || result.length == 0) {
                        output.put("Result", null);
                    } else {
                        output.put("Result", result[0]);
                    }
                    logger.debug("Received sync response {} completeing work item {}", (Object)result, (Object)workItem.getId());
                    manager.completeWorkItem(workItem.getId(), output);
                    return;
                }
                case ASYNC: {
                    final ClientCallback callback = new ClientCallback();
                    final long workItemId = workItem.getId();
                    final String deploymentId = this.nonNull(((WorkItemImpl)workItem).getDeploymentId());
                    final long processInstanceId = workItem.getProcessInstanceId();
                    client.invoke(callback, operationRef, parameters);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object[] result = callback.get((long)WebServiceWorkItemHandler.this.asyncTimeout, TimeUnit.SECONDS);
                                HashMap<String, Object> output = new HashMap<String, Object>();
                                if (callback.isDone()) {
                                    if (result == null) {
                                        output.put("Result", null);
                                    } else {
                                        output.put("Result", result[0]);
                                    }
                                }
                                logger.debug("Received async response {} completeing work item {}", (Object)result, (Object)workItemId);
                                RuntimeManager manager = RuntimeManagerRegistry.get().getManager(deploymentId);
                                if (manager != null) {
                                    RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                                    engine.getKieSession().getWorkItemManager().completeWorkItem(workItemId, output);
                                    manager.disposeRuntimeEngine(engine);
                                } else {
                                    WebServiceWorkItemHandler.this.ksession.getWorkItemManager().completeWorkItem(workItemId, output);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new RuntimeException("Error encountered while invoking ws operation asynchronously", e);
                            }
                        }
                    }).start();
                    return;
                }
                case ONEWAY: {
                    ClientCallback callbackFF = new ClientCallback();
                    client.invoke(callbackFF, operationRef, parameters);
                    logger.debug("One way operation, not going to wait for response, completing work item {}", (Object)workItem.getId());
                    manager.completeWorkItem(workItem.getId(), new HashMap());
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Client getWSClient(WorkItem workItem, String interfaceRef) {
        if (this.clients.containsKey(interfaceRef)) {
            return this.clients.get(interfaceRef);
        }
        WebServiceWorkItemHandler webServiceWorkItemHandler = this;
        synchronized (webServiceWorkItemHandler) {
            if (this.clients.containsKey(interfaceRef)) {
                return this.clients.get(interfaceRef);
            }
            String importLocation = (String)workItem.getParameter("Url");
            String importNamespace = (String)workItem.getParameter("Namespace");
            if (importLocation != null && importLocation.trim().length() > 0 && importNamespace != null && importNamespace.trim().length() > 0) {
                Client client = this.getDynamicClientFactory().createClient(importLocation, new QName(importNamespace, interfaceRef), this.getInternalClassLoader(), null);
                this.setClientTimeout(workItem, client);
                this.clients.put(interfaceRef, client);
                return client;
            }
            long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
            WorkflowProcessImpl process = (WorkflowProcessImpl)this.ksession.getProcessInstance(processInstanceId).getProcess();
            List typedImports = (List)process.getMetaData("Bpmn2Imports");
            if (typedImports != null) {
                Client client = null;
                for (Bpmn2Import importObj : typedImports) {
                    if (!WSDL_IMPORT_TYPE.equalsIgnoreCase(importObj.getType())) continue;
                    try {
                        client = this.getDynamicClientFactory().createClient(importObj.getLocation(), new QName(importObj.getNamespace(), interfaceRef), this.getInternalClassLoader(), null);
                        this.setClientTimeout(workItem, client);
                        this.clients.put(interfaceRef, client);
                        return client;
                    }
                    catch (Exception e) {
                        logger.error("Error when creating WS Client", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    private void setClientTimeout(WorkItem workItem, Client client) {
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy policy = conduit.getClient();
        long connectionTimeout = this.defaultJbpmCxfClientConnectionTimeout;
        String connectionTimeoutStr = (String)workItem.getParameter("ConnectionTimeout");
        if (connectionTimeoutStr != null && !connectionTimeoutStr.trim().isEmpty()) {
            connectionTimeout = Long.valueOf(connectionTimeoutStr);
        }
        long receiveTimeout = this.defaultJbpmCxfClientReceiveTimeout;
        String receiveTimeoutStr = (String)workItem.getParameter("ReceiveTimeout");
        if (receiveTimeoutStr != null && !receiveTimeoutStr.trim().isEmpty()) {
            receiveTimeout = Long.valueOf(receiveTimeoutStr);
        }
        logger.debug("connectionTimeout = {}, receiveTimeout = {}", (Object)connectionTimeout, (Object)receiveTimeout);
        policy.setConnectionTimeout(connectionTimeout);
        policy.setReceiveTimeout(receiveTimeout);
    }

    protected synchronized DynamicClientFactory getDynamicClientFactory() {
        if (this.dcf == null) {
            this.dcf = JaxWsDynamicClientFactory.newInstance();
        }
        return this.dcf;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    private ClassLoader getInternalClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected String nonNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public void close() {
        if (this.clients != null) {
            for (Client client : this.clients.values()) {
                client.destroy();
            }
        }
    }

    protected void applyAuthorization(String userName, String password, Client client) {
        if (userName != null && password != null) {
            HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
            AuthorizationPolicy authorizationPolicy = new AuthorizationPolicy();
            authorizationPolicy.setUserName(userName);
            authorizationPolicy.setPassword(password);
            authorizationPolicy.setAuthorizationType("Basic");
            httpConduit.setAuthorization(authorizationPolicy);
        } else {
            logger.warn("UserName and Password must be provided to set the authorization policy.");
        }
    }

    public void setClients(ConcurrentHashMap<String, Client> clients) {
        this.clients = clients;
    }

    static enum WSMode {
        SYNC,
        ASYNC,
        ONEWAY;

    }
}

