/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.model.Global;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;

public final class DroolsScoringUniConstraintStream<Solution_, A>
extends DroolsAbstractUniConstraintStream<Solution_, A> {
    private final DroolsAbstractUniConstraintStream<Solution_, A> parent;
    private final boolean noMatchWeigher;
    private final ToIntFunction<A> intMatchWeigher;
    private final ToLongFunction<A> longMatchWeigher;
    private final Function<A, BigDecimal> bigDecimalMatchWeigher;

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent) {
        this(constraintFactory, parent, true, null, null, null);
    }

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, ToIntFunction<A> intMatchWeigher) {
        this(constraintFactory, parent, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, ToLongFunction<A> longMatchWeigher) {
        this(constraintFactory, parent, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private DroolsScoringUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, boolean noMatchWeigher, ToIntFunction<A> intMatchWeigher, ToLongFunction<A> longMatchWeigher, Function<A, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory);
        this.parent = parent;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    @Override
    public List<RuleItemBuilder<?>> createRuleItemBuilders(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        DroolsUniCondition<A> condition = this.parent.getCondition();
        if (this.intMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.intMatchWeigher);
        }
        if (this.longMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.longMatchWeigher);
        }
        if (this.bigDecimalMatchWeigher != null) {
            return condition.completeWithScoring(scoreHolderGlobal, this.bigDecimalMatchWeigher);
        }
        if (this.noMatchWeigher) {
            return condition.completeWithScoring(scoreHolderGlobal);
        }
        throw new IllegalStateException("Impossible state: noMatchWeigher (" + this.noMatchWeigher + ").");
    }

    @Override
    public boolean isGroupByAllowed() {
        return false;
    }

    @Override
    public DroolsUniCondition<A> getCondition() {
        throw new UnsupportedOperationException("Scoring stream does not have its own UniCondition.");
    }

    public String toString() {
        return "Scoring()";
    }
}

