/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands.error;

import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.executor.commands.error.AutoAckErrorCommand;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;
import org.kie.api.task.model.Status;

public class TaskAutoAckErrorCommand
extends AutoAckErrorCommand {
    private static final String RULE = "Tasks that previously failed but now are in one of the statuses - completed, failed, exited, obsolete, error";

    @Override
    protected List<ExecutionErrorInfo> findErrorsToAck(EntityManager em) {
        String findTaskErrorsQuery = "select error from ExecutionErrorInfo error where error.type = :type and error.acknowledged =:acknowledged and error.activityId in (select at.taskId from AuditTaskImpl at where status in (:status))";
        List errorsToAck = em.createQuery(findTaskErrorsQuery).setParameter("type", (Object)"Task").setParameter("acknowledged", (Object)new Short("0")).setParameter("status", Arrays.asList(Status.Completed.toString(), Status.Exited.toString(), Status.Failed.toString(), Status.Obsolete.toString(), Status.Error.toString())).getResultList();
        return errorsToAck;
    }

    @Override
    protected String getAckRule() {
        return RULE;
    }
}

