/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.scenariosimulation;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.scenariosimulation.ScenarioSimulationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Test scenario execution")
@Path(value="server/containers/{containerId}/scesim")
public class ScenarioSimulationResource {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioSimulationResource.class);
    private final ScenarioSimulationService scenarioSimulationService;

    public ScenarioSimulationResource(ScenarioSimulationService scenarioSimulationService) {
        this.scenarioSimulationService = scenarioSimulationService;
    }

    @ApiOperation(value="Execute given test scenario against specified container", response=ServiceResponse.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container not found"), @ApiResponse(code=400, message="Malformed test scenario file")})
    @POST
    @Produces(value={"application/xml", "application/json"})
    public Response executeSimulation(@Context HttpHeaders headers, @ApiParam(value="Container id", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="Test scenario file content to be executed", required=true) String rawContent) {
        KieContainer kieContainer = null;
        ScenarioSimulationModel model = null;
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.scenarioSimulationService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            kieContainer = this.scenarioSimulationService.getKieContainerById(containerId);
        }
        catch (Exception e) {
            return RestUtils.createCorrectVariant(this.createFailedServiceResponse("Impossible to find container with id " + containerId, e), (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        try {
            model = this.scenarioSimulationService.parseModel(rawContent);
        }
        catch (Exception e) {
            return RestUtils.createCorrectVariant(this.createFailedServiceResponse("Test scenario parsing error", e), (HttpHeaders)headers, (Response.Status)Response.Status.BAD_REQUEST, (Header[])new Header[]{conversationIdHeader});
        }
        try {
            return RestUtils.createCorrectVariant((Object)this.scenarioSimulationService.executeScenario(kieContainer, model), (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RestUtils.internalServerError((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected ServiceResponse<ScenarioSimulationResource> createFailedServiceResponse(String errorMessage, Exception e) {
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, errorMessage + ": " + e.getMessage());
    }
}

