/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchResultReference
implements Serializable,
LDAPResponse {
    private static final long serialVersionUID = 5675961266319346053L;
    private final Control[] controls;
    private final int messageID;
    private final String[] referralURLs;

    public SearchResultReference(String[] referralURLs, Control[] controls) {
        this(-1, referralURLs, controls);
    }

    public SearchResultReference(int messageID, String[] referralURLs, Control[] controls) {
        Validator.ensureNotNull(referralURLs);
        this.messageID = messageID;
        this.referralURLs = referralURLs;
        this.controls = controls == null ? NO_CONTROLS : controls;
    }

    static SearchResultReference readSearchReferenceFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        try {
            ArrayList<String> refList = new ArrayList<String>(5);
            ASN1StreamReaderSequence refSequence = reader.beginSequence();
            while (refSequence.hasMoreElements()) {
                refList.add(reader.readString());
            }
            String[] referralURLs = new String[refList.size()];
            refList.toArray(referralURLs);
            Control[] controls = NO_CONTROLS;
            if (messageSequence.hasMoreElements()) {
                ArrayList<Control> controlList = new ArrayList<Control>(5);
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controlList.add(Control.readFrom(reader));
                }
                controls = new Control[controlList.size()];
                controlList.toArray(controls);
            }
            return new SearchResultReference(messageID, referralURLs, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_SEARCH_REFERENCE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getMessageID() {
        return this.messageID;
    }

    public String[] getReferralURLs() {
        return this.referralURLs;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(String oid) {
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        int i;
        buffer.append("SearchResultReference(referralURLs={");
        for (i = 0; i < this.referralURLs.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.referralURLs[i]);
        }
        buffer.append('}');
        if (this.messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(this.messageID);
        }
        buffer.append(", controls={");
        for (i = 0; i < this.controls.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.controls[i].toString(buffer);
        }
        buffer.append("})");
    }
}

