/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ResponseInit {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetHeadersUnionType {
    @JsOverlay
    static GetHeadersUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Headers asHeaders() {
      return Js.cast(this);
    }

    @JsOverlay
    default JsPropertyMap<String> asJsPropertyMap() {
      return Js.cast(this);
    }

    @JsOverlay
    default String[][] asStringArrayArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isHeaders() {
      return (Object) this instanceof Headers;
    }

    @JsOverlay
    default boolean isStringArrayArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsProperty
  GetHeadersUnionType getHeaders();

  @JsProperty
  double getStatus();

  @JsProperty
  String getStatusText();

  @JsProperty
  void setHeaders(GetHeadersUnionType headers);

  @JsOverlay
  default void setHeaders(Headers headers) {
    setHeaders(Js.<GetHeadersUnionType>uncheckedCast(headers));
  }

  @JsOverlay
  default void setHeaders(JsPropertyMap<String> headers) {
    setHeaders(Js.<GetHeadersUnionType>uncheckedCast(headers));
  }

  @JsOverlay
  default void setHeaders(String[][] headers) {
    setHeaders(Js.<GetHeadersUnionType>uncheckedCast(headers));
  }

  @JsProperty
  void setStatus(double status);

  @JsProperty
  void setStatusText(String statusText);
}
