/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.DSL;
import org.drools.model.DeclarationSource;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Function1;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;

public abstract class DroolsRuleStructure {
    private final LongSupplier variableIdSupplier;

    protected DroolsRuleStructure(LongSupplier variableIdSupplier) {
        this.variableIdSupplier = variableIdSupplier;
    }

    public final <X> Variable<? extends X> createVariable(Class<X> clz, String name) {
        return DSL.declarationOf(clz, (String)this.decorateVariableName(name));
    }

    public final <X> Variable<? extends X> createVariable(Class<X> clz, String name, DeclarationSource source) {
        return DSL.declarationOf(clz, (String)this.decorateVariableName(name), (DeclarationSource)source);
    }

    private String decorateVariableName(String name) {
        return "$var" + this.variableIdSupplier.getAsLong() + "_" + name;
    }

    public final <X> Variable<X> createVariable(String name) {
        return this.createVariable(Object.class, name);
    }

    public final <X> Variable<X> createVariable(String name, DeclarationSource source) {
        return this.createVariable(Object.class, name, source);
    }

    public final List<RuleItemBuilder<?>> finish(ConsequenceBuilder.AbstractValidBuilder<?> consequence) {
        List<RuleItemBuilder<?>> closed = this.getClosedRuleItems();
        List<RuleItemBuilder<?>> open = this.getOpenRuleItems();
        ArrayList result = new ArrayList(closed.size() + open.size() + 2);
        result.addAll(closed);
        result.addAll(open);
        result.add((RuleItemBuilder<?>)this.getPrimaryPattern().build());
        result.add((RuleItemBuilder<?>)consequence);
        return result;
    }

    public LongSupplier getVariableIdSupplier() {
        return this.variableIdSupplier;
    }

    public abstract DroolsPatternBuilder<Object> getPrimaryPattern();

    public abstract List<RuleItemBuilder<?>> getOpenRuleItems();

    public abstract List<RuleItemBuilder<?>> getClosedRuleItems();

    private List<RuleItemBuilder<?>> mergeClosedItems(RuleItemBuilder<?> ... newClosedItems) {
        return Stream.concat(this.getClosedRuleItems().stream(), Stream.of(newClosedItems)).collect(Collectors.toList());
    }

    public <NewA> DroolsUniRuleStructure<NewA> recollect(Variable<NewA> newA, ViewItem<?> accumulatePattern) {
        DroolsPatternBuilder<NewA> newPrimaryPattern = new DroolsPatternBuilder<NewA>(newA);
        List<ViewItem<?>> newOpenItems = Collections.singletonList(accumulatePattern);
        return new DroolsUniRuleStructure<NewA>(newA, newPrimaryPattern, newOpenItems, this.getClosedRuleItems(), this.getVariableIdSupplier());
    }

    public <NewA> DroolsUniRuleStructure<NewA> regroup(Variable<Set<NewA>> newASource, PatternDSL.PatternDef<Set<NewA>> collectPattern, ViewItem<?> accumulatePattern) {
        Variable newA = this.createVariable("groupKey", (DeclarationSource)DSL.from(newASource));
        DroolsPatternBuilder newPrimaryPattern = new DroolsPatternBuilder(newA);
        return new DroolsUniRuleStructure(newA, newPrimaryPattern, Arrays.asList(collectPattern), this.mergeClosedItems(new RuleItemBuilder[]{accumulatePattern}), this.getVariableIdSupplier());
    }

    public <NewA, NewB> DroolsBiRuleStructure<NewA, NewB> regroupBi(Variable<Set<BiTuple<NewA, NewB>>> newSource, PatternDSL.PatternDef<Set<BiTuple<NewA, NewB>>> collectPattern, ViewItem<?> accumulatePattern) {
        Variable<BiTuple> newTuple = this.createVariable(BiTuple.class, "groupKey", (DeclarationSource)DSL.from(newSource));
        Variable newA = this.createVariable("newA");
        Variable newB = this.createVariable("newB");
        DroolsPatternBuilder<BiTuple> newPrimaryPattern = new DroolsPatternBuilder<BiTuple>(newTuple).expand(p -> p.bind(newA, (Function1 & Serializable)tuple -> tuple.a)).expand(p -> p.bind(newB, (Function1 & Serializable)tuple -> tuple.b));
        return new DroolsBiRuleStructure(newA, newB, newPrimaryPattern, Arrays.asList(collectPattern), this.mergeClosedItems(new RuleItemBuilder[]{accumulatePattern}), this.getVariableIdSupplier());
    }

    public <NewA, NewB, NewC> DroolsTriRuleStructure<NewA, NewB, NewC> regroupBiToTri(Variable<Set<TriTuple<NewA, NewB, NewC>>> newSource, PatternDSL.PatternDef<Set<TriTuple<NewA, NewB, NewC>>> collectPattern, ViewItem<?> accumulatePattern) {
        Variable<TriTuple> newTuple = this.createVariable(TriTuple.class, "groupKey", (DeclarationSource)DSL.from(newSource));
        Variable newA = this.createVariable("newA");
        Variable newB = this.createVariable("newB");
        Variable newC = this.createVariable("newC");
        DroolsPatternBuilder<TriTuple> newPrimaryPattern = new DroolsPatternBuilder<TriTuple>(newTuple).expand(p -> p.bind(newA, (Function1 & Serializable)tuple -> tuple.a)).expand(p -> p.bind(newB, (Function1 & Serializable)tuple -> tuple.b)).expand(p -> p.bind(newC, (Function1 & Serializable)tuple -> tuple.c));
        return new DroolsTriRuleStructure(newA, newB, newC, newPrimaryPattern, Arrays.asList(collectPattern), this.mergeClosedItems(new RuleItemBuilder[]{accumulatePattern}), this.getVariableIdSupplier());
    }

    public <NewA, NewB, NewC, NewD> DroolsQuadRuleStructure<NewA, NewB, NewC, NewD> regroupBiToQuad(Variable<Set<QuadTuple<NewA, NewB, NewC, NewD>>> newSource, PatternDSL.PatternDef<Set<QuadTuple<NewA, NewB, NewC, NewD>>> collectPattern, ViewItem<?> accumulatePattern) {
        Variable<QuadTuple> newTuple = this.createVariable(QuadTuple.class, "groupKey", (DeclarationSource)DSL.from(newSource));
        Variable newA = this.createVariable("newA");
        Variable newB = this.createVariable("newB");
        Variable newC = this.createVariable("newC");
        Variable newD = this.createVariable("newD");
        DroolsPatternBuilder<QuadTuple> newPrimaryPattern = new DroolsPatternBuilder<QuadTuple>(newTuple).expand(p -> p.bind(newA, (Function1 & Serializable)tuple -> tuple.a)).expand(p -> p.bind(newB, (Function1 & Serializable)tuple -> tuple.b)).expand(p -> p.bind(newC, (Function1 & Serializable)tuple -> tuple.c)).expand(p -> p.bind(newD, (Function1 & Serializable)tuple -> tuple.d));
        return new DroolsQuadRuleStructure(newA, newB, newC, newD, newPrimaryPattern, Arrays.asList(collectPattern), this.mergeClosedItems(new RuleItemBuilder[]{accumulatePattern}), this.getVariableIdSupplier());
    }
}

