/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.tri;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;

public final class SingleTriJoiner<A, B, C>
extends AbstractTriJoiner<A, B, C> {
    private final BiFunction<A, B, ?> leftMapping;
    private final JoinerType joinerType;
    private final Function<C, ?> rightMapping;

    public SingleTriJoiner(BiFunction<A, B, ?> leftMapping, JoinerType joinerType, Function<C, ?> rightMapping) {
        this.leftMapping = leftMapping;
        this.joinerType = joinerType;
        this.rightMapping = rightMapping;
    }

    public BiFunction<A, B, ?> getLeftMapping() {
        return this.leftMapping;
    }

    public JoinerType getJoinerType() {
        return this.joinerType;
    }

    public Function<C, ?> getRightMapping() {
        return this.rightMapping;
    }

    @Override
    public BiFunction<A, B, Object> getLeftMapping(int joinerId) {
        return this.leftMapping;
    }

    @Override
    public BiFunction<A, B, Object[]> getLeftCombinedMapping() {
        return (a, b) -> new Object[]{this.leftMapping.apply(a, b)};
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return new JoinerType[]{this.joinerType};
    }

    @Override
    public Function<C, Object> getRightMapping(int joinerId) {
        return this.rightMapping;
    }

    @Override
    public Function<C, Object[]> getRightCombinedMapping() {
        return c -> new Object[]{this.rightMapping.apply(c)};
    }
}

